/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.kerberos.shared.store.KerberosCatalog;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.AddPrincipal;
import org.apache.directory.server.kerberos.shared.store.operations.ChangePassword;
import org.apache.directory.server.kerberos.shared.store.operations.DeletePrincipal;
import org.apache.directory.server.kerberos.shared.store.operations.GetAllPrincipals;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.server.protocol.shared.catalog.Catalog;
import org.apache.directory.server.protocol.shared.catalog.GetCatalog;
import org.apache.directory.server.protocol.shared.store.ContextOperation;

class MultiBaseSearch
implements PrincipalStore {
    private final Catalog catalog;
    private final DirectoryService directoryService;

    MultiBaseSearch(String catalogBaseDn, DirectoryService directoryService) {
        this.directoryService = directoryService;
        try {
            LdapContext ctx = directoryService.getJndiContext(catalogBaseDn);
            this.catalog = new KerberosCatalog((Map)this.execute(ctx, (ContextOperation)new GetCatalog()));
        }
        catch (Exception e) {
            String message = "Failed to get catalog context " + catalogBaseDn;
            throw new ServiceConfigurationException(message, (Throwable)e);
        }
    }

    public String addPrincipal(PrincipalStoreEntry entry) throws Exception {
        try {
            return (String)this.execute(this.getDirContext(entry.getRealmName()), new AddPrincipal(entry));
        }
        catch (NamingException ne) {
            String message = "Failed to get initial context " + entry.getRealmName();
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
    }

    public String deletePrincipal(KerberosPrincipal principal) throws Exception {
        try {
            return (String)this.execute(this.getDirContext(principal.getRealm()), new DeletePrincipal(principal));
        }
        catch (NamingException ne) {
            String message = "Failed to get initial context " + principal.getRealm();
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
    }

    public PrincipalStoreEntry[] getAllPrincipals(String realm) throws Exception {
        try {
            return (PrincipalStoreEntry[])this.execute(this.getDirContext(realm), new GetAllPrincipals());
        }
        catch (NamingException ne) {
            String message = "Failed to get initial context " + realm;
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
    }

    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        try {
            return (PrincipalStoreEntry)this.execute(this.getDirContext(principal.getRealm()), new GetPrincipal(principal));
        }
        catch (NamingException ne) {
            String message = "Failed to get initial context " + principal.getRealm();
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
    }

    public String changePassword(KerberosPrincipal principal, String newPassword) throws Exception {
        try {
            return (String)this.execute(this.getDirContext(principal.getRealm()), new ChangePassword(principal, newPassword));
        }
        catch (NamingException ne) {
            String message = "Failed to get initial context " + principal.getRealm();
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
    }

    private Object execute(DirContext ctx, ContextOperation operation) throws Exception {
        return operation.execute(ctx, null);
    }

    private DirContext getDirContext(String name) throws NamingException {
        return this.directoryService.getJndiContext(this.catalog.getBaseDn(name));
    }
}

