/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.keytab;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.mina.common.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeytabDecoder {
    KeytabDecoder() {
    }

    byte[] getKeytabVersion(ByteBuffer buffer) {
        byte[] version = new byte[2];
        buffer.get(version);
        return version;
    }

    List<KeytabEntry> getKeytabEntries(ByteBuffer buffer) {
        ArrayList<KeytabEntry> entries = new ArrayList<KeytabEntry>();
        while (buffer.remaining() > 0) {
            int size = buffer.getInt();
            byte[] entry = new byte[size];
            buffer.get(entry);
            entries.add(this.getKeytabEntry(ByteBuffer.wrap((byte[])entry)));
        }
        return entries;
    }

    private KeytabEntry getKeytabEntry(ByteBuffer buffer) {
        String principalName = this.getPrincipalName(buffer);
        long principalType = buffer.getUnsignedInt();
        long time = buffer.getUnsignedInt();
        KerberosTime timeStamp = new KerberosTime(time * 1000L);
        byte keyVersion = buffer.get();
        EncryptionKey key = this.getKeyBlock(buffer, keyVersion);
        return new KeytabEntry(principalName, principalType, timeStamp, keyVersion, key);
    }

    private String getPrincipalName(ByteBuffer buffer) {
        int count = buffer.getUnsignedShort();
        String realm = this.getCountedString(buffer);
        StringBuffer principalNameBuffer = new StringBuffer();
        for (int ii = 0; ii < count; ++ii) {
            String nameComponent = this.getCountedString(buffer);
            principalNameBuffer.append(nameComponent);
            if (ii >= count - 1) continue;
            principalNameBuffer.append("\\");
        }
        principalNameBuffer.append("@" + realm);
        return principalNameBuffer.toString();
    }

    private EncryptionKey getKeyBlock(ByteBuffer buffer, int keyVersion) {
        int type = buffer.getUnsignedShort();
        byte[] keyblock = this.getCountedBytes(buffer);
        EncryptionType encryptionType = EncryptionType.getTypeByOrdinal(type);
        EncryptionKey key = new EncryptionKey(encryptionType, keyblock);
        return key;
    }

    private String getCountedString(ByteBuffer buffer) {
        int length = buffer.getUnsignedShort();
        byte[] data = new byte[length];
        buffer.get(data);
        try {
            return new String(data, "ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            return "";
        }
    }

    private byte[] getCountedBytes(ByteBuffer buffer) {
        int length = buffer.getUnsignedShort();
        byte[] data = new byte[length];
        buffer.get(data);
        return data;
    }
}

