/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.KerberosMessageType;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptedDataDecoder;
import org.apache.directory.server.kerberos.shared.messages.application.PrivateMessage;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class PrivateMessageDecoder {
    public PrivateMessage decode(byte[] encodedPrivateMessage) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedPrivateMessage);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        DERSequence privateMessage = (DERSequence)app.getObject();
        return this.decodePrivateMessageSequence(privateMessage);
    }

    private PrivateMessage decodePrivateMessageSequence(DERSequence sequence) {
        PrivateMessage message = new PrivateMessage();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERInteger tag0 = (DERInteger)derObject;
                    message.setProtocolVersionNumber(tag0.intValue());
                    break;
                }
                case 1: {
                    DERInteger tag1 = (DERInteger)derObject;
                    message.setMessageType(KerberosMessageType.getTypeByOrdinal(tag1.intValue()));
                    break;
                }
                case 3: {
                    DERSequence tag3 = (DERSequence)derObject;
                    message.setEncryptedPart(EncryptedDataDecoder.decode(tag3));
                }
            }
        }
        return message;
    }
}

