/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.io.decoder.Decoder;
import org.apache.directory.server.kerberos.shared.io.decoder.DecoderFactory;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptionKeyDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.HostAddressDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.KerberosTimeDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.LastRequestDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.PrincipalNameDecoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.components.EncKdcRepPart;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosPrincipalModifier;
import org.apache.directory.server.kerberos.shared.messages.value.flags.TicketFlags;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERBitString;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERGeneralizedTime;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncKdcRepPartDecoder
implements Decoder,
DecoderFactory {
    public Decoder getDecoder() {
        return new EncKdcRepPartDecoder();
    }

    public Encodable decode(byte[] encoded) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encoded);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        DERSequence sequence = (DERSequence)app.getObject();
        return this.decodeEncKdcRepPartSequence(sequence);
    }

    private EncKdcRepPart decodeEncKdcRepPartSequence(DERSequence sequence) {
        EncKdcRepPart modifier = new EncKdcRepPart();
        KerberosPrincipalModifier principalModifier = new KerberosPrincipalModifier();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERSequence tag0 = (DERSequence)derObject;
                    modifier.setKey(EncryptionKeyDecoder.decode(tag0));
                    break;
                }
                case 1: {
                    DERSequence tag1 = (DERSequence)derObject;
                    modifier.setLastRequest(LastRequestDecoder.decodeSequence(tag1));
                    break;
                }
                case 2: {
                    DERInteger tag2 = (DERInteger)derObject;
                    modifier.setNonce(new Integer(tag2.intValue()));
                    break;
                }
                case 3: {
                    DERGeneralizedTime tag3 = (DERGeneralizedTime)derObject;
                    modifier.setKeyExpiration(KerberosTimeDecoder.decode(tag3));
                    break;
                }
                case 4: {
                    DERBitString tag4 = (DERBitString)derObject;
                    modifier.setFlags(new TicketFlags(tag4.getOctets()));
                    break;
                }
                case 5: {
                    DERGeneralizedTime tag5 = (DERGeneralizedTime)derObject;
                    modifier.setAuthTime(KerberosTimeDecoder.decode(tag5));
                    break;
                }
                case 6: {
                    DERGeneralizedTime tag6 = (DERGeneralizedTime)derObject;
                    modifier.setStartTime(KerberosTimeDecoder.decode(tag6));
                    break;
                }
                case 7: {
                    DERGeneralizedTime tag7 = (DERGeneralizedTime)derObject;
                    modifier.setEndTime(KerberosTimeDecoder.decode(tag7));
                    break;
                }
                case 8: {
                    DERGeneralizedTime tag8 = (DERGeneralizedTime)derObject;
                    modifier.setRenewTill(KerberosTimeDecoder.decode(tag8));
                    break;
                }
                case 9: {
                    DERGeneralString tag9 = (DERGeneralString)derObject;
                    principalModifier.setRealm(tag9.getString());
                    break;
                }
                case 10: {
                    DERSequence tag10 = (DERSequence)derObject;
                    principalModifier.setPrincipalName(PrincipalNameDecoder.decode(tag10));
                    break;
                }
                case 11: {
                    DERSequence tag11 = (DERSequence)derObject;
                    modifier.setClientAddresses(HostAddressDecoder.decodeSequence(tag11));
                }
            }
        }
        modifier.setServerPrincipal(principalModifier.getKerberosPrincipal());
        return modifier;
    }
}

