/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.service;

import java.security.InvalidKeyException;
import java.security.SecureRandom;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;

public class SessionKeyFactory {
    private static final SecureRandom random = new SecureRandom();

    public static EncryptionKey getSessionKey() {
        byte[] raw = new byte[7];
        random.nextBytes(raw);
        byte[] keyBytes = SessionKeyFactory.addParity(raw);
        try {
            if (DESKeySpec.isWeak(keyBytes, 0)) {
                keyBytes = SessionKeyFactory.getStrongKey(keyBytes);
            }
        }
        catch (InvalidKeyException ike) {
            return null;
        }
        SecretKeySpec key = new SecretKeySpec(keyBytes, "DES");
        byte[] subSessionKey = key.getEncoded();
        return new EncryptionKey(EncryptionType.DES_CBC_MD5, subSessionKey);
    }

    static byte[] addParity(byte[] sevenBytes) {
        byte[] result = new byte[8];
        int resultIndex = 1;
        int bitCount = 0;
        for (int i = 0; i < 56; ++i) {
            boolean bit;
            boolean bl = bit = (sevenBytes[6 - i / 8] & 1 << i % 8) > 0;
            if (bit) {
                int n = 7 - resultIndex / 8;
                result[n] = (byte)(result[n] | 1 << resultIndex % 8 & 0xFF);
                ++bitCount;
            }
            if ((i + 1) % 7 == 0) {
                if (bitCount % 2 == 0) {
                    int n = 7 - resultIndex / 8;
                    result[n] = (byte)(result[n] | 1);
                }
                ++resultIndex;
                bitCount = 0;
            }
            ++resultIndex;
        }
        return result;
    }

    private static byte[] getStrongKey(byte[] keyValue) {
        keyValue[7] = (byte)(keyValue[7] ^ 0xF0);
        return keyValue;
    }
}

