/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.krbCred.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.krbCred.KrbCredContainer;
import org.apache.directory.shared.kerberos.codec.ticket.TicketContainer;
import org.apache.directory.shared.kerberos.messages.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreTickets
extends GrammarAction<KrbCredContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreTickets.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public void action(KrbCredContainer krbCredContainer) throws DecoderException {
        TLV tlv = krbCredContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        Asn1Decoder decoder = new Asn1Decoder();
        TicketContainer ticketContainer = new TicketContainer(krbCredContainer.getStream());
        krbCredContainer.rewind();
        decoder.decode(krbCredContainer.getStream(), (Asn1Container)ticketContainer);
        Ticket ticket = ticketContainer.getTicket();
        krbCredContainer.getKrbCred().addTicket(ticket);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        krbCredContainer.updateParent();
        if (IS_DEBUG) {
            LOG.debug("Ticket : {}", (Object)ticket);
        }
    }
}

