/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.encryptedData.EncryptedDataContainer;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReadEncryptedPart<E extends Asn1Container>
extends GrammarAction<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadEncryptedPart.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AbstractReadEncryptedPart(String name) {
        super(name);
    }

    protected abstract void setEncryptedData(EncryptedData var1, E var2);

    public final void action(E container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        Asn1Decoder encryptedDataDecoder = new Asn1Decoder();
        EncryptedDataContainer encryptedDataContainer = new EncryptedDataContainer();
        encryptedDataContainer.setStream(container.getStream());
        encryptedDataDecoder.decode(container.getStream(), (Asn1Container)encryptedDataContainer);
        EncryptedData encryptedData = encryptedDataContainer.getEncryptedData();
        if (IS_DEBUG) {
            LOG.debug("EncryptedData : " + (Object)((Object)encryptedData));
        }
        this.setEncryptedData(encryptedData, container);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        container.updateParent();
        container.setGrammarEndAllowed(true);
    }
}

