/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.bindRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.codec.decorators.BindRequestDecorator;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreName
extends GrammarAction<LdapMessageContainer<BindRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreName() {
        super("Store BindRequest Name value");
    }

    @Override
    public void action(LdapMessageContainer<BindRequestDecorator> container) throws DecoderException {
        BindRequest bindRequestMessage = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            bindRequestMessage.setName("");
        } else {
            byte[] nameBytes = tlv.getValue().getData();
            String nameStr = Strings.utf8ToString(nameBytes);
            try {
                new Dn(nameStr);
                bindRequestMessage.setName(nameStr);
            }
            catch (LdapInvalidDnException ine) {
                String msg = "Incorrect DN given : " + nameStr + " (" + Strings.dumpBytes(nameBytes) + ") is invalid";
                LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                BindResponseImpl response = new BindResponseImpl(bindRequestMessage.getMessageId());
                throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
            }
        }
        if (IS_DEBUG) {
            LOG.debug(" The Bind name is {}", (Object)bindRequestMessage.getName());
        }
    }
}

