/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.util.Strings;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;

public class KerberosUtils {
    public static final int NULL = -1;
    public static final List<String> EMPTY_PRINCIPAL_NAME = new ArrayList<String>();
    private static final Map<String, String> cipherAlgoMap = new LinkedHashMap<String, String>();
    private static final Set<EncryptionType> oldEncTypes = new HashSet<EncryptionType>();

    public static boolean isKerberosString(byte[] value) {
        if (value == null) {
            return false;
        }
        for (byte b : value) {
            if (b >= 32 && b <= 126) continue;
            return false;
        }
        return true;
    }

    public static String getAlgoNameFromEncType(EncryptionType encType) {
        String cipherName = Strings.toLowerCaseAscii(encType.getName());
        for (Map.Entry<String, String> entry : cipherAlgoMap.entrySet()) {
            if (!cipherName.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("Unknown algorithm name for the encryption type " + (Object)((Object)encType));
    }

    static {
        cipherAlgoMap.put("rc4", "ArcFourHmac");
        cipherAlgoMap.put("aes256", "AES256");
        cipherAlgoMap.put("aes128", "AES128");
        cipherAlgoMap.put("des3", "DESede");
        cipherAlgoMap.put("des", "DES");
        oldEncTypes.add(EncryptionType.DES_CBC_CRC);
        oldEncTypes.add(EncryptionType.DES_CBC_MD4);
        oldEncTypes.add(EncryptionType.DES_CBC_MD5);
        oldEncTypes.add(EncryptionType.DES_EDE3_CBC_ENV_OID);
        oldEncTypes.add(EncryptionType.DES3_CBC_MD5);
        oldEncTypes.add(EncryptionType.DES3_CBC_SHA1);
        oldEncTypes.add(EncryptionType.DES3_CBC_SHA1_KD);
        oldEncTypes.add(EncryptionType.DSAWITHSHA1_CMSOID);
        oldEncTypes.add(EncryptionType.MD5WITHRSAENCRYPTION_CMSOID);
        oldEncTypes.add(EncryptionType.SHA1WITHRSAENCRYPTION_CMSOID);
        oldEncTypes.add(EncryptionType.RC2CBC_ENVOID);
        oldEncTypes.add(EncryptionType.RSAENCRYPTION_ENVOID);
        oldEncTypes.add(EncryptionType.RSAES_OAEP_ENV_OID);
        oldEncTypes.add(EncryptionType.RC4_HMAC);
    }
}

