/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.security;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.i18n.I18n;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TlsKeyGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(TlsKeyGenerator.class);
    public static final String TLS_KEY_INFO_OC = "tlsKeyInfo";
    public static final String PRIVATE_KEY_AT = "privateKey";
    public static final String PUBLIC_KEY_AT = "publicKey";
    public static final String KEY_ALGORITHM_AT = "keyAlgorithm";
    public static final String PRIVATE_KEY_FORMAT_AT = "privateKeyFormat";
    public static final String PUBLIC_KEY_FORMAT_AT = "publicKeyFormat";
    public static final String USER_CERTIFICATE_AT = "userCertificate";
    private static final String BASE_DN = "OU=Directory, O=ASF, C=US";
    public static final String CERTIFICATE_PRINCIPAL_DN = "CN=ApacheDS,OU=Directory, O=ASF, C=US";
    private static final String ALGORITHM = "RSA";
    private static final int KEY_SIZE = 2048;
    public static final long YEAR_MILLIS = 31536000000L;

    private TlsKeyGenerator() {
    }

    public static X509Certificate getCertificate(Entry entry) throws LdapException {
        X509Certificate cert = null;
        CertificateFactory certFactory = null;
        try {
            certFactory = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (Exception e) {
            LdapException ne = new LdapException(I18n.err(I18n.ERR_286, new Object[0]));
            ne.initCause(e);
            throw ne;
        }
        byte[] certBytes = entry.get(USER_CERTIFICATE_AT).getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(certBytes);
        try {
            cert = (X509Certificate)certFactory.generateCertificate(in);
        }
        catch (CertificateException e) {
            LdapException ne = new LdapException(I18n.err(I18n.ERR_287, new Object[0]));
            ne.initCause(e);
            throw ne;
        }
        return cert;
    }

    public static KeyPair getKeyPair(Entry entry) throws LdapException {
        PublicKey publicKey = null;
        PrivateKey privateKey = null;
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance(ALGORITHM);
        }
        catch (Exception e) {
            LdapException ne = new LdapException(I18n.err(I18n.ERR_288, ALGORITHM));
            ne.initCause(e);
            throw ne;
        }
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(entry.get(PRIVATE_KEY_AT).getBytes());
        try {
            privateKey = keyFactory.generatePrivate(privateKeySpec);
        }
        catch (Exception e) {
            LdapException ne = new LdapException(I18n.err(I18n.ERR_289, new Object[0]));
            ne.initCause(e);
            throw ne;
        }
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(entry.get(PUBLIC_KEY_AT).getBytes());
        try {
            publicKey = keyFactory.generatePublic(publicKeySpec);
        }
        catch (InvalidKeySpecException e) {
            LdapException ne = new LdapException(I18n.err(I18n.ERR_290, new Object[0]));
            ne.initCause(e);
            throw ne;
        }
        return new KeyPair(publicKey, privateKey);
    }

    public static void addKeyPair(Entry entry) throws LdapException {
        String subjectDn = null;
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            subjectDn = "CN=" + hostName + "," + BASE_DN;
        }
        catch (Exception e) {
            LOG.warn("failed to create certificate subject name from host name", e);
            subjectDn = CERTIFICATE_PRINCIPAL_DN;
        }
        TlsKeyGenerator.addKeyPair(entry, CERTIFICATE_PRINCIPAL_DN, subjectDn, ALGORITHM, 2048);
    }

    public static void addKeyPair(Entry entry, String issuerDN, String subjectDN, String keyAlgo) throws LdapException {
        TlsKeyGenerator.addKeyPair(entry, issuerDN, subjectDN, keyAlgo, 2048);
    }

    public static void addKeyPair(Entry entry, String issuerDN, String subjectDN, String keyAlgo, int keySize) throws LdapException {
        Date startDate = new Date();
        Date expiryDate = new Date(System.currentTimeMillis() + 31536000000L);
        TlsKeyGenerator.addKeyPair(entry, issuerDN, subjectDN, startDate, expiryDate, keyAlgo, keySize, null, false);
    }

    public static void addKeyPair(Entry entry, String issuerDN, String subjectDN, Date startDate, Date expiryDate, String keyAlgo, int keySize, PrivateKey optionalSigningKey, boolean isCA) throws LdapException {
        Attribute objectClass = entry.get("objectClass");
        if (objectClass == null) {
            entry.put("objectClass", TLS_KEY_INFO_OC, "inetOrgPerson");
        } else {
            objectClass.add(TLS_KEY_INFO_OC, "inetOrgPerson");
        }
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(keyAlgo);
        }
        catch (NoSuchAlgorithmException e) {
            LdapException ne = new LdapException(I18n.err(I18n.ERR_291, new Object[0]));
            ne.initCause(e);
            throw ne;
        }
        generator.initialize(keySize);
        KeyPair keypair = generator.genKeyPair();
        entry.put(KEY_ALGORITHM_AT, keyAlgo);
        PrivateKey privateKey = keypair.getPrivate();
        entry.put(PRIVATE_KEY_AT, (byte[][])new byte[][]{privateKey.getEncoded()});
        entry.put(PRIVATE_KEY_FORMAT_AT, privateKey.getFormat());
        LOG.debug("PrivateKey: {}", (Object)privateKey);
        PublicKey publicKey = keypair.getPublic();
        entry.put(PUBLIC_KEY_AT, (byte[][])new byte[][]{publicKey.getEncoded()});
        entry.put(PUBLIC_KEY_FORMAT_AT, publicKey.getFormat());
        LOG.debug("PublicKey: {}", (Object)publicKey);
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        X500Principal issuerName = new X500Principal(issuerDN);
        X500Principal subjectName = new X500Principal(subjectDN);
        certGen.setSerialNumber(serialNumber);
        certGen.setIssuerDN(issuerName);
        certGen.setNotBefore(startDate);
        certGen.setNotAfter(expiryDate);
        certGen.setSubjectDN(subjectName);
        certGen.setPublicKey(publicKey);
        certGen.setSignatureAlgorithm("SHA256With" + keyAlgo);
        certGen.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(isCA));
        certGen.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth}));
        try {
            PrivateKey signingKey = optionalSigningKey != null ? optionalSigningKey : privateKey;
            X509Certificate cert = certGen.generate(signingKey, "BC");
            entry.put(USER_CERTIFICATE_AT, (byte[][])new byte[][]{cert.getEncoded()});
            LOG.debug("X509 Certificate: {}", (Object)cert);
        }
        catch (Exception e) {
            LdapException ne = new LdapException(I18n.err(I18n.ERR_292, new Object[0]));
            ne.initCause(e);
            throw ne;
        }
        LOG.info("Keys and self signed certificate successfully generated.");
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

