/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

public class DnComparator
extends LdapComparator<Object> {
    private static final long serialVersionUID = 2L;
    private transient SchemaManager schemaManager;

    public DnComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String dn1, String dn2) {
        if (dn1 == null) {
            if (dn2 == null) {
                return 0;
            }
            return -1;
        }
        return dn1.compareTo(dn2);
    }

    @Override
    public int compare(Object obj0, Object obj1) {
        if (obj0 instanceof String && obj1 instanceof String) {
            return this.compare((String)obj0, (String)obj1);
        }
        Dn dn0 = null;
        Dn dn1 = null;
        try {
            dn0 = this.getDn(obj0);
            dn1 = this.getDn(obj1);
        }
        catch (LdapException e) {
            return -1;
        }
        int dn0Size = dn0.getRdns().size();
        int dn1Size = dn1.getRdns().size();
        if (dn0.equals(dn1)) {
            return 0;
        }
        if (dn0Size > dn1Size) {
            return -1;
        }
        if (dn1Size > dn0Size) {
            return 1;
        }
        for (int i2 = dn0Size - 1; i2 >= 0; --i2) {
            int comp = dn0.getRdn(i2).compareTo(dn1.getRdn(i2));
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    private Dn getDn(Object obj) throws LdapInvalidDnException {
        Dn dn;
        if (obj instanceof Dn) {
            dn = (Dn)obj;
            dn = dn.isSchemaAware() ? dn : new Dn(this.schemaManager, dn);
        } else if (obj instanceof String) {
            dn = new Dn(this.schemaManager, (String)obj);
        } else {
            throw new IllegalStateException(I18n.err(I18n.ERR_13720_CANNOT_HANDLE_DN_COMPARISONS, obj == null ? null : obj.getClass()));
        }
        return dn;
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

