/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.protocol.mina;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.codec.api.LdapEncoder;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.util.Strings;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapProtocolEncoder
implements ProtocolEncoder {
    private static final Logger CODEC_LOG = LoggerFactory.getLogger(Loggers.CODEC_LOG.getName());
    private LdapApiService codec;
    private ThreadLocal<Asn1Buffer> threadLocalStorage = new ThreadLocal();

    public LdapProtocolEncoder() {
        this(LdapApiServiceFactory.getSingleton());
    }

    public LdapProtocolEncoder(LdapApiService ldapApiService) {
        this.codec = ldapApiService;
    }

    @Override
    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        ByteBuffer encoded;
        Asn1Buffer asn1Buffer = this.threadLocalStorage.get();
        if (asn1Buffer == null) {
            asn1Buffer = new Asn1Buffer();
            this.threadLocalStorage.set(asn1Buffer);
        }
        try {
            LdapEncoder.encodeMessage(asn1Buffer, this.codec, (Message)message);
            encoded = asn1Buffer.getBytes();
        }
        catch (EncoderException e) {
            CODEC_LOG.error(I18n.err(I18n.ERR_14000_ERROR_ENCODING_MESSAGE, message, e.getMessage()));
            throw e;
        }
        finally {
            asn1Buffer.clear();
        }
        IoBuffer ioBuffer = IoBuffer.wrap(encoded);
        if (CODEC_LOG.isDebugEnabled()) {
            byte[] dumpBuffer = new byte[encoded.limit()];
            encoded.get(dumpBuffer);
            encoded.flip();
            CODEC_LOG.debug(I18n.msg(I18n.MSG_14003_ENCODED_LDAP_MESSAGE, message, Strings.dumpBytes(dumpBuffer)));
        }
        out.write(ioBuffer);
    }

    @Override
    public void dispose(IoSession session) throws Exception {
    }
}

