/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.Serializable;
import java.util.Comparator;
import jdbm.I18n;

public final class ByteArrayComparator
implements Comparator<byte[]>,
Serializable {
    static final long serialVersionUID = 1L;

    @Override
    public int compare(byte[] obj1, byte[] obj2) {
        if (obj1 == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_525, new Object[0]));
        }
        if (obj2 == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_526, new Object[0]));
        }
        return ByteArrayComparator.compareByteArray(obj1, obj2);
    }

    public static int compareByteArray(byte[] thisKey, byte[] otherKey) {
        int len = Math.min(thisKey.length, otherKey.length);
        for (int i2 = 0; i2 < len; ++i2) {
            if (thisKey[i2] >= 0) {
                if (otherKey[i2] >= 0) {
                    if (thisKey[i2] < otherKey[i2]) {
                        return -1;
                    }
                    if (thisKey[i2] <= otherKey[i2]) continue;
                    return 1;
                }
                return -1;
            }
            if (otherKey[i2] >= 0) {
                return 1;
            }
            if (thisKey[i2] < otherKey[i2]) {
                return -1;
            }
            if (thisKey[i2] <= otherKey[i2]) continue;
            return 1;
        }
        if (thisKey.length == otherKey.length) {
            return 0;
        }
        if (thisKey.length < otherKey.length) {
            return -1;
        }
        return 1;
    }
}

