/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify;

import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyResponseContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyResponseDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyResponseStatesEnum;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyResponseImpl;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordModifyResponseGrammar
extends AbstractGrammar<PasswordModifyResponseContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordModifyResponseGrammar.class);
    private static Grammar<PasswordModifyResponseContainer> instance = new PasswordModifyResponseGrammar();

    public PasswordModifyResponseGrammar() {
        this.setName(PasswordModifyResponseGrammar.class.getName());
        this.transitions = new GrammarTransition[PasswordModifyResponseStatesEnum.LAST_PASSWORD_MODIFY_RESPONSE_STATE.ordinal()][256];
        this.transitions[PasswordModifyResponseStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<PasswordModifyResponseContainer>(PasswordModifyResponseStatesEnum.START_STATE, PasswordModifyResponseStatesEnum.PASSWORD_MODIFY_RESPONSE_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), new GrammarAction<PasswordModifyResponseContainer>("Init PasswordModifyResponse"){

            @Override
            public void action(PasswordModifyResponseContainer container) {
                PasswordModifyResponseDecorator passwordModifyResponse = new PasswordModifyResponseDecorator(LdapApiServiceFactory.getSingleton(), new PasswordModifyResponseImpl());
                container.setPasswordModifyResponse(passwordModifyResponse);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[PasswordModifyResponseStatesEnum.PASSWORD_MODIFY_RESPONSE_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition<PasswordModifyResponseContainer>(PasswordModifyResponseStatesEnum.PASSWORD_MODIFY_RESPONSE_SEQUENCE_STATE, PasswordModifyResponseStatesEnum.GEN_PASSWORD_STATE, 128, new GrammarAction<PasswordModifyResponseContainer>("Set PasswordModifyResponse user identity"){

            @Override
            public void action(PasswordModifyResponseContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] genPassword = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08205_GEN_PASSWORD, new Object[0]));
                }
                if (genPassword == null) {
                    genPassword = Strings.EMPTY_BYTES;
                }
                container.getPwdModifyResponse().setGenPassword(genPassword);
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<PasswordModifyResponseContainer> getInstance() {
        return instance;
    }
}

