/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionRequestDecoder;
import org.apache.directory.api.ldap.extras.extended.endTransaction.EndTransactionRequest;
import org.apache.directory.api.ldap.extras.extended.endTransaction.EndTransactionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndTransactionRequestDecorator
extends ExtendedRequestDecorator<EndTransactionRequest>
implements EndTransactionRequest {
    private static final Logger LOG = LoggerFactory.getLogger(EndTransactionRequestDecorator.class);
    private EndTransactionRequest endTransactionRequest;
    private int requestLength = 0;

    public EndTransactionRequestDecorator(LdapApiService codec, EndTransactionRequest decoratedMessage) {
        super(codec, decoratedMessage);
        this.endTransactionRequest = decoratedMessage;
    }

    @Override
    public EndTransactionResponse getResultResponse() {
        return (EndTransactionResponse)this.endTransactionRequest.getResultResponse();
    }

    @Override
    public boolean getCommit() {
        return this.endTransactionRequest.getCommit();
    }

    @Override
    public void setCommit(boolean commit) {
        this.endTransactionRequest.setCommit(commit);
    }

    @Override
    public byte[] getTransactionId() {
        return this.endTransactionRequest.getTransactionId();
    }

    @Override
    public void setTransactionId(byte[] transactionId) {
        this.endTransactionRequest.setTransactionId(transactionId);
    }

    @Override
    public void setRequestValue(byte[] requestValue) {
        EndTransactionRequestDecoder decoder = new EndTransactionRequestDecoder();
        try {
            if (requestValue != null) {
                this.endTransactionRequest = decoder.decode(requestValue);
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_08217_PAYLOAD_DECODING_ERROR, new Object[0]), e);
            throw new RuntimeException(e);
        }
    }

    int computeLengthInternal() {
        this.requestLength = 0;
        if (!this.endTransactionRequest.getCommit()) {
            this.requestLength = 3;
        }
        if (this.endTransactionRequest.getTransactionId() != null) {
            int len = this.endTransactionRequest.getTransactionId().length;
            this.requestLength += 1 + TLV.getNbBytes(len) + len;
        }
        return 1 + TLV.getNbBytes(this.requestLength) + this.requestLength;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        byte[] identifier;
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes(this.requestLength));
        if (!this.getCommit()) {
            BerValue.encode(bb, false);
        }
        if ((identifier = this.endTransactionRequest.getTransactionId()) != null) {
            BerValue.encode(bb, identifier);
        }
        return bb;
    }
}

