/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.standalone;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.IntermediateResponseFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.osgi.DefaultLdapCodecService;
import org.apache.directory.api.ldap.codec.standalone.CodecFactoryUtil;
import org.apache.directory.api.util.Strings;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneLdapApiService
extends DefaultLdapCodecService {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneLdapApiService.class);
    public static final String CONTROLS_LIST = "apacheds.controls";
    public static final String EXTENDED_OPERATIONS_LIST = "apacheds.extendedOperations";
    public static final String INTERMEDIATE_RESPONSES_LIST = "apacheds.intermediateResponses";
    private static final String OLD_DEFAULT_CONTROLS_LIST = "default.controls";
    private static final String OLD_EXTRA_EXTENDED_OPERATION_LIST = "extra.extendedOperations";

    public StandaloneLdapApiService() throws Exception {
        this(StandaloneLdapApiService.getControlsFromSystemProperties(), StandaloneLdapApiService.getExtendedOperationsFromSystemProperties(), StandaloneLdapApiService.getIntermediateResponsesFromSystemProperties());
    }

    public StandaloneLdapApiService(List<String> controls, List<String> extendedOperations, List<String> intermediateResponses) throws Exception {
        CodecFactoryUtil.loadStockControls(this.getControlFactories(), this);
        CodecFactoryUtil.loadStockExtendedOperations(this.getExtendedOperationFactories(), this);
        CodecFactoryUtil.loadStockIntermediateResponses(this.getIntermediateResponseFactories(), this);
        this.loadControls(controls);
        this.loadExtendedOperations(extendedOperations);
        this.loadIntermediateResponse(intermediateResponses);
        if (this.getProtocolCodecFactory() == null) {
            try {
                Class<?> clazz = Class.forName("org.apache.directory.api.ldap.codec.protocol.mina.LdapProtocolCodecFactory");
                Constructor<?> constructor = clazz.getConstructor(LdapApiService.class);
                if (constructor != null) {
                    this.setProtocolCodecFactory((ProtocolCodecFactory)constructor.newInstance(this));
                } else {
                    this.setProtocolCodecFactory((ProtocolCodecFactory)clazz.newInstance());
                }
            }
            catch (Exception cause) {
                throw new RuntimeException(I18n.err(I18n.ERR_06000_FAILED_TO_LOAD_DEFAULT_CODEC_FACTORY, new Object[0]), cause);
            }
        }
    }

    private static List<String> getControlsFromSystemProperties() {
        ArrayList<String> controlsList;
        block3: {
            block2: {
                controlsList = new ArrayList<String>();
                String controlsString = System.getProperty(CONTROLS_LIST);
                if (Strings.isEmpty(controlsString)) break block2;
                for (String control : controlsString.split(",")) {
                    controlsList.add(control);
                }
                break block3;
            }
            String oldDefaultControlsString = System.getProperty(OLD_DEFAULT_CONTROLS_LIST);
            if (Strings.isEmpty(oldDefaultControlsString)) break block3;
            for (String control : oldDefaultControlsString.split(",")) {
                controlsList.add(control);
            }
        }
        return controlsList;
    }

    private static List<String> getExtendedOperationsFromSystemProperties() {
        ArrayList<String> extendedOperationsList;
        block3: {
            block2: {
                extendedOperationsList = new ArrayList<String>();
                String defaultExtendedOperationsList = System.getProperty(EXTENDED_OPERATIONS_LIST);
                if (Strings.isEmpty(defaultExtendedOperationsList)) break block2;
                for (String extendedOperation : defaultExtendedOperationsList.split(",")) {
                    extendedOperationsList.add(extendedOperation);
                }
                break block3;
            }
            String oldDefaultExtendedOperationsString = System.getProperty(OLD_EXTRA_EXTENDED_OPERATION_LIST);
            if (Strings.isEmpty(oldDefaultExtendedOperationsString)) break block3;
            for (String extendedOperation : oldDefaultExtendedOperationsString.split(",")) {
                extendedOperationsList.add(extendedOperation);
            }
        }
        return extendedOperationsList;
    }

    private static List<String> getIntermediateResponsesFromSystemProperties() {
        ArrayList<String> intermediateResponsesList = new ArrayList<String>();
        String defaultIntermediateResponsesList = System.getProperty(INTERMEDIATE_RESPONSES_LIST);
        if (!Strings.isEmpty(defaultIntermediateResponsesList)) {
            for (String intermediateResponse : defaultIntermediateResponsesList.split(",")) {
                intermediateResponsesList.add(intermediateResponse);
            }
        }
        return intermediateResponsesList;
    }

    private void loadControls(List<String> controlsList) throws Exception {
        if (!controlsList.isEmpty()) {
            for (String controlFQCN : controlsList) {
                this.loadControl(controlFQCN);
            }
        }
    }

    private void loadControl(String controlFQCN) throws Exception {
        if (this.getControlFactories().containsKey(controlFQCN)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_06003_CONTROL_FACTORY_ALREADY_LOADED, controlFQCN));
            }
            return;
        }
        Class[] types = new Class[]{LdapApiService.class};
        Class<?> clazz = Class.forName(controlFQCN.trim());
        Constructor<?> constructor = clazz.getConstructor(types);
        ControlFactory factory = (ControlFactory)constructor.newInstance(this);
        this.getControlFactories().put(factory.getOid(), factory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06004_REGISTERED_CONTROL_FACTORY, factory.getOid()));
        }
    }

    private void loadExtendedOperations(List<String> extendedOperationsList) throws Exception {
        if (!extendedOperationsList.isEmpty()) {
            for (String extendedOperationFQCN : extendedOperationsList) {
                this.loadExtendedOperation(extendedOperationFQCN);
            }
        }
    }

    private void loadExtendedOperation(String extendedOperationFQCN) throws Exception {
        if (this.getExtendedOperationFactories().containsKey(extendedOperationFQCN)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_06005_EXTENDED_OP_FACTORY_ALREADY_LOADED, extendedOperationFQCN));
            }
            return;
        }
        Class[] types = new Class[]{LdapApiService.class};
        Class<?> clazz = Class.forName(extendedOperationFQCN.trim());
        Constructor<?> constructor = clazz.getConstructor(types);
        ExtendedOperationFactory factory = (ExtendedOperationFactory)constructor.newInstance(this);
        this.getExtendedOperationFactories().put(factory.getOid(), factory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, factory.getOid()));
        }
    }

    private void loadIntermediateResponse(List<String> intermediateResponsesList) throws Exception {
        if (!intermediateResponsesList.isEmpty()) {
            for (String intermediateResponseFQCN : intermediateResponsesList) {
                this.loadIntermediateResponse(intermediateResponseFQCN);
            }
        }
    }

    private void loadIntermediateResponse(String intermediateResponseFQCN) throws Exception {
        if (this.getIntermediateResponseFactories().containsKey(intermediateResponseFQCN)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_06006_INTERMEDIATE_FACTORY_ALREADY_LOADED, intermediateResponseFQCN));
            }
            return;
        }
        Class[] types = new Class[]{LdapApiService.class};
        Class<?> clazz = Class.forName(intermediateResponseFQCN.trim());
        Constructor<?> constructor = clazz.getConstructor(types);
        IntermediateResponseFactory factory = (IntermediateResponseFactory)constructor.newInstance(this);
        this.getIntermediateResponseFactories().put(factory.getOid(), factory);
        if (LOG.isInfoEnabled()) {
            LOG.info("Registered pre-bundled Intermediate Response factory: {}", (Object)factory.getOid());
        }
    }
}

