/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.bind;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.BindResponseDecorator;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreServerSASLCreds
extends GrammarAction<LdapMessageContainer<BindResponseDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreServerSASLCreds.class);

    public StoreServerSASLCreds() {
        super("Store server sasl credentials value");
    }

    @Override
    public void action(LdapMessageContainer<BindResponseDecorator> container) {
        TLV tlv = container.getCurrentTLV();
        byte[] serverSaslCreds = tlv.getLength() == 0 ? Strings.EMPTY_BYTES : tlv.getValue().getData();
        BindResponse response = container.getMessage();
        response.setServerSaslCreds(serverSaslCreds);
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05168_SASL_CREDENTIALS_VALUE_STORED, new Object[0]));
        }
    }
}

