/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestTimeLimit
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestTimeLimit.class);

    public StoreSearchRequestTimeLimit() {
        super("Store SearchRequest timeLimit");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequest searchRequest = (SearchRequest)container.getMessage().getDecorated();
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        int timeLimit = 0;
        try {
            timeLimit = IntegerDecoder.parse(value, 0, Integer.MAX_VALUE);
        }
        catch (IntegerDecoderException ide) {
            String msg = I18n.err(I18n.ERR_05152_BAD_TIME_LIMIT, value.toString());
            LOG.error(msg);
            throw new DecoderException(msg, ide);
        }
        searchRequest.setTimeLimit(timeLimit);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05164_TIME_LIMIT_SET_TO, timeLimit));
        }
    }
}

