/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.compare;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.codec.decorators.CompareRequestDecorator;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.CompareResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreCompareRequestEntryName
extends GrammarAction<LdapMessageContainer<CompareRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreCompareRequestEntryName.class);

    public StoreCompareRequestEntryName() {
        super("Store CompareRequest entry Name");
    }

    @Override
    public void action(LdapMessageContainer<CompareRequestDecorator> container) throws DecoderException {
        Dn entry;
        CompareRequest compareRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            throw new DecoderException(I18n.err(I18n.ERR_05119_NULL_ENTRY, new Object[0]));
        }
        byte[] dnBytes = tlv.getValue().getData();
        String dnStr = Strings.utf8ToString(dnBytes);
        try {
            entry = new Dn(dnStr);
        }
        catch (LdapInvalidDnException ine) {
            String msg = I18n.err(I18n.ERR_05113_INVALID_DN, dnStr, Strings.dumpBytes(dnBytes));
            LOG.error(I18n.err(I18n.ERR_05114_ERROR_MESSAGE, msg, ine.getMessage()));
            CompareResponseImpl response = new CompareResponseImpl(compareRequest.getMessageId());
            throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
        }
        compareRequest.setName(entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05123_COMPARING_DN, entry));
        }
    }
}

