/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.compare;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.CompareRequestDecorator;
import org.apache.directory.api.ldap.model.message.CompareRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitCompareRequest
extends GrammarAction<LdapMessageContainer<CompareRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitCompareRequest.class);

    public InitCompareRequest() {
        super("Compare Request initialization");
    }

    @Override
    public void action(LdapMessageContainer<CompareRequestDecorator> container) {
        CompareRequestImpl internalCompareRequest = new CompareRequestImpl();
        internalCompareRequest.setMessageId(container.getMessageId());
        CompareRequestDecorator compareRequest = new CompareRequestDecorator(container.getLdapCodecService(), internalCompareRequest);
        container.setMessage(compareRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05120_COMPARE_REQUEST, new Object[0]));
        }
    }
}

