/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schema.manager.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.exception.LdapProtocolErrorException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaExceptionCodes;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.LoadableSchemaObject;
import org.apache.directory.api.ldap.model.schema.LoggingSchemaErrorHandler;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaErrorHandler;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.SchemaObjectWrapper;
import org.apache.directory.api.ldap.model.schema.SchemaUtils;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.normalizers.OidNormalizer;
import org.apache.directory.api.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ComparatorRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DitContentRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.DitStructureRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ImmutableAttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ImmutableComparatorRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ImmutableDitContentRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ImmutableDitStructureRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ImmutableLdapSyntaxRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ImmutableMatchingRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ImmutableMatchingRuleUseRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ImmutableNameFormRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ImmutableNormalizerRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ImmutableObjectClassRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ImmutableSyntaxCheckerRegistry;
import org.apache.directory.api.ldap.model.schema.registries.LdapSyntaxRegistry;
import org.apache.directory.api.ldap.model.schema.registries.LowerCaseKeyMap;
import org.apache.directory.api.ldap.model.schema.registries.MatchingRuleRegistry;
import org.apache.directory.api.ldap.model.schema.registries.MatchingRuleUseRegistry;
import org.apache.directory.api.ldap.model.schema.registries.NameFormRegistry;
import org.apache.directory.api.ldap.model.schema.registries.NormalizerRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ObjectClassRegistry;
import org.apache.directory.api.ldap.model.schema.registries.OidRegistry;
import org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.model.schema.registries.SyntaxCheckerRegistry;
import org.apache.directory.api.ldap.schema.loader.EntityFactory;
import org.apache.directory.api.ldap.schema.loader.JarLdifSchemaLoader;
import org.apache.directory.api.ldap.schema.loader.SchemaEntityFactory;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchemaManager
implements SchemaManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchemaManager.class);
    private Dn namingContext;
    private volatile Registries registries;
    private final EntityFactory factory;
    private Map<String, Set<String>> schemaDependencies = new HashMap<String, Set<String>>();
    private Map<String, Schema> schemaMap = new LowerCaseKeyMap();
    private boolean isRelaxed = false;
    private SchemaErrorHandler errorHandler;

    public DefaultSchemaManager() {
        this(false, DefaultSchemaManager.jarLdifSchemaLoader().getAllSchemas());
        try {
            this.loadAllEnabled();
        }
        catch (LdapException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_16077_SCHEMA_MANAGER_CANT_BE_LOADED, (Object[])new Object[]{e.getMessage()}));
            throw new RuntimeException(e.getMessage());
        }
    }

    private static SchemaLoader jarLdifSchemaLoader() {
        try {
            return new JarLdifSchemaLoader();
        }
        catch (IOException | LdapException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_16080_SCHEMA_LOADER_CANT_BE_CREATED, (Object[])new Object[]{e.getMessage()}));
            throw new RuntimeException(e.getMessage());
        }
    }

    public DefaultSchemaManager(Collection<Schema> schemas) {
        this(false, schemas);
    }

    public DefaultSchemaManager(SchemaLoader schemaLoader) {
        this(schemaLoader.isRelaxed(), schemaLoader.getAllSchemas());
    }

    public DefaultSchemaManager(boolean relaxed, Collection<Schema> schemas) {
        this.namingContext = Dn.ROOT_DSE;
        for (Schema schema : schemas) {
            this.schemaMap.put(schema.getSchemaName(), schema);
        }
        this.registries = new Registries();
        this.factory = new SchemaEntityFactory();
        this.isRelaxed = relaxed;
        this.setErrorHandler((SchemaErrorHandler)new LoggingSchemaErrorHandler());
    }

    private Registries cloneRegistries() throws LdapException {
        try {
            Registries clonedRegistries = this.registries.clone();
            clonedRegistries.checkRefInteg();
            clonedRegistries.setRelaxed();
            return clonedRegistries;
        }
        catch (CloneNotSupportedException cnse) {
            throw new LdapOtherException(cnse.getMessage(), (Throwable)cnse);
        }
    }

    private Schema[] toArray(String ... schemas) throws LdapException {
        Schema[] schemaArray = new Schema[schemas.length];
        int n = 0;
        for (String schemaName : schemas) {
            Schema schema = this.schemaMap.get(schemaName);
            if (schema == null) {
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((I18n)I18n.ERR_16078_CANNOT_LOAD_UNKNOWN_SCHEMA, (Object[])new Object[]{schemaName}));
            }
            schemaArray[n++] = schema;
        }
        return schemaArray;
    }

    private void addSchemaObjects(Schema schema, Registries registries) throws LdapException {
        registries.addSchema(schema.getSchemaName());
        this.schemaMap.put(schema.getSchemaName(), schema);
        try {
            this.addComparators(schema, registries);
            this.addNormalizers(schema, registries);
            this.addSyntaxCheckers(schema, registries);
            this.addSyntaxes(schema, registries);
            this.addMatchingRules(schema, registries);
            this.addAttributeTypes(schema, registries);
            this.addObjectClasses(schema, registries);
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    private void deleteSchemaObjects(Schema schema, Registries registries) throws LdapException {
        Map schemaObjects = registries.getObjectBySchemaName();
        Set content = (Set)schemaObjects.get(Strings.toLowerCaseAscii((String)schema.getSchemaName()));
        ArrayList<SchemaObject> toBeDeleted = new ArrayList<SchemaObject>();
        if (content != null) {
            for (SchemaObjectWrapper schemaObjectWrapper : content) {
                toBeDeleted.add(schemaObjectWrapper.get());
            }
            for (SchemaObject schemaObject : toBeDeleted) {
                registries.delete(schemaObject);
            }
        }
    }

    public boolean disable(Schema ... schemas) throws LdapException {
        boolean disabled = false;
        this.errorHandler.reset();
        Registries clonedRegistries = this.cloneRegistries();
        clonedRegistries.setRelaxed();
        for (Schema schema : schemas) {
            this.unload(clonedRegistries, schema);
        }
        this.errorHandler.reset();
        clonedRegistries.buildReferences();
        clonedRegistries.clear();
        if (!this.errorHandler.wasError()) {
            clonedRegistries.checkRefInteg();
            if (!this.errorHandler.wasError()) {
                for (Schema schema : schemas) {
                    this.unload(this.registries, schema);
                    schema.disable();
                }
                this.errorHandler.reset();
                this.registries.buildReferences();
                this.registries.setStrict();
                disabled = true;
            }
        }
        clonedRegistries.clear();
        return disabled;
    }

    public boolean disable(String ... schemaNames) throws LdapException {
        Schema[] schemas = this.toArray(schemaNames);
        return this.disable(schemas);
    }

    public boolean disabledRelaxed(Schema ... schemas) {
        return false;
    }

    public boolean disabledRelaxed(String ... schemas) {
        return false;
    }

    public List<Schema> getDisabled() {
        ArrayList<Schema> disabled = new ArrayList<Schema>();
        for (Schema schema : this.registries.getLoadedSchemas().values()) {
            if (!schema.isDisabled()) continue;
            disabled.add(schema);
        }
        return disabled;
    }

    public boolean enable(Schema ... schemas) throws LdapException {
        boolean enabled = false;
        this.errorHandler.reset();
        Registries clonedRegistries = this.cloneRegistries();
        clonedRegistries.setRelaxed();
        HashSet<Schema> disabledSchemas = new HashSet<Schema>();
        for (Object schema : schemas) {
            if (schema.getDependencies() != null) {
                for (String dependency : schema.getDependencies()) {
                    Schema dependencySchema = this.schemaMap.get(dependency);
                    if (!dependencySchema.isDisabled()) continue;
                    disabledSchemas.add(dependencySchema);
                }
            }
            schema.enable();
            this.load(clonedRegistries, (Schema)schema);
        }
        for (Schema disabledSchema : disabledSchemas) {
            if (!disabledSchema.isEnabled()) continue;
            disabledSchema.disable();
        }
        clonedRegistries.buildReferences();
        clonedRegistries.clear();
        if (!this.errorHandler.wasError()) {
            clonedRegistries.checkRefInteg();
            if (!this.errorHandler.wasError()) {
                for (Object schema : schemas) {
                    schema.enable();
                    this.load(this.registries, (Schema)schema);
                }
                this.registries.buildReferences();
                this.registries.setStrict();
                enabled = true;
            }
        }
        clonedRegistries.clear();
        return enabled;
    }

    public boolean enable(String ... schemaNames) throws LdapException {
        Schema[] schemas = this.toArray(schemaNames);
        return this.enable(schemas);
    }

    public boolean enableRelaxed(Schema ... schemas) {
        return false;
    }

    public boolean enableRelaxed(String ... schemas) {
        return false;
    }

    public List<Schema> getEnabled() {
        ArrayList<Schema> enabled = new ArrayList<Schema>();
        for (Schema schema : this.registries.getLoadedSchemas().values()) {
            if (!schema.isEnabled()) continue;
            enabled.add(schema);
        }
        return enabled;
    }

    public List<Schema> getAllSchemas() {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (Schema schema : this.schemaMap.values()) {
            if (!schema.isEnabled()) continue;
            schemas.add(schema);
        }
        return schemas;
    }

    public List<Throwable> getErrors() {
        return this.errorHandler.getErrors();
    }

    public Registries getRegistries() {
        return this.registries;
    }

    public boolean isDisabledAccepted() {
        return false;
    }

    public boolean load(Schema ... schemas) throws LdapException {
        if (schemas.length == 0) {
            return true;
        }
        boolean loaded = false;
        this.errorHandler.reset();
        Registries clonedRegistries = this.cloneRegistries();
        clonedRegistries.setRelaxed();
        for (Schema schema : schemas) {
            boolean singleSchemaLoaded = this.load(clonedRegistries, schema);
            if (singleSchemaLoaded) continue;
            return false;
        }
        clonedRegistries.buildReferences();
        if (!this.errorHandler.wasError()) {
            clonedRegistries.checkRefInteg();
            if (!this.errorHandler.wasError()) {
                this.registries.setRelaxed();
                for (Schema schema : schemas) {
                    this.load(this.registries, schema);
                    if (schema.getDependencies() != null) {
                        for (String dep : schema.getDependencies()) {
                            Set<String> deps = this.schemaDependencies.get(dep);
                            if (deps == null) {
                                deps = new HashSet<String>();
                                deps.add(schema.getSchemaName());
                            }
                            this.schemaDependencies.put(dep, deps);
                        }
                    }
                    this.schemaMap.put(schema.getSchemaName(), schema);
                }
                this.registries.buildReferences();
                this.registries.setStrict();
                loaded = true;
            }
        }
        clonedRegistries.clear();
        return loaded;
    }

    public boolean load(String ... schemaNames) throws LdapException {
        if (schemaNames.length == 0) {
            return true;
        }
        Schema[] schemas = this.toArray(schemaNames);
        return this.load(schemas);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean load(Registries registries, Schema schema) throws LdapException {
        if (schema == null) {
            if (!LOG.isInfoEnabled()) return false;
            LOG.info(I18n.msg((I18n)I18n.MSG_16013_SCHEMA_IS_NULL, (Object[])new Object[0]));
            return false;
        }
        if (registries.isSchemaLoaded(schema.getSchemaName())) {
            return true;
        }
        if (schema.isDisabled()) {
            if (!registries.isDisabledAccepted()) return false;
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg((I18n)I18n.MSG_16014_LOADING_DISABLED_SCHEMA, (Object[])new Object[]{schema.getSchemaName(), schema}));
            }
            registries.schemaLoaded(schema);
            this.addSchemaObjects(schema, registries);
            return true;
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg((I18n)I18n.MSG_16015_LOADING_ENABLED_SCHEMA, (Object[])new Object[]{schema.getSchemaName(), schema}));
            }
            if (schema.getDependencies() != null) {
                for (String dependency : schema.getDependencies()) {
                    Schema dependencySchema = this.schemaMap.get(dependency);
                    if (dependencySchema == null) {
                        String msg = I18n.err((I18n)I18n.ERR_16035_CANNOT_LOAD_SCHEMA, (Object[])new Object[]{schema.getSchemaName()});
                        if (LOG.isInfoEnabled()) {
                            LOG.info(msg);
                        }
                        LdapProtocolErrorException error = new LdapProtocolErrorException(msg);
                        this.errorHandler.handle(LOG, msg, (Throwable)error);
                        return false;
                    }
                    if (!dependencySchema.isDisabled()) continue;
                    dependencySchema.enable();
                    if (this.load(registries, dependencySchema)) continue;
                    dependencySchema.disable();
                    return false;
                }
            }
            registries.schemaLoaded(schema);
            this.addSchemaObjects(schema, registries);
        }
        return true;
    }

    private boolean unload(Registries registries, Schema schema) throws LdapException {
        if (schema == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg((I18n)I18n.MSG_16013_SCHEMA_IS_NULL, (Object[])new Object[0]));
            }
            return false;
        }
        if (!registries.isSchemaLoaded(schema.getSchemaName())) {
            return true;
        }
        if (schema.isEnabled()) {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg((I18n)I18n.MSG_16016_UNLOADING_SCHEMA, (Object[])new Object[]{schema.getSchemaName(), schema}));
            }
            this.deleteSchemaObjects(schema, registries);
            registries.schemaUnloaded(schema);
        }
        return true;
    }

    private void addAttributeTypes(Schema schema, Registries registries) throws LdapException, IOException {
        if (schema.getSchemaLoader() == null) {
            return;
        }
        for (Entry entry : schema.getSchemaLoader().loadAttributeTypes(new Schema[]{schema})) {
            AttributeType attributeType = this.factory.getAttributeType(this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, (SchemaObject)attributeType, schema);
        }
    }

    private void addComparators(Schema schema, Registries registries) throws LdapException, IOException {
        if (schema.getSchemaLoader() == null) {
            return;
        }
        for (Entry entry : schema.getSchemaLoader().loadComparators(new Schema[]{schema})) {
            LdapComparator<?> comparator = this.factory.getLdapComparator((SchemaManager)this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, (SchemaObject)comparator, schema);
        }
    }

    private void addMatchingRules(Schema schema, Registries registries) throws LdapException, IOException {
        if (schema.getSchemaLoader() == null) {
            return;
        }
        for (Entry entry : schema.getSchemaLoader().loadMatchingRules(new Schema[]{schema})) {
            MatchingRule matchingRule = this.factory.getMatchingRule(this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, (SchemaObject)matchingRule, schema);
        }
    }

    private void addNormalizers(Schema schema, Registries registries) throws LdapException, IOException {
        if (schema.getSchemaLoader() == null) {
            return;
        }
        for (Entry entry : schema.getSchemaLoader().loadNormalizers(new Schema[]{schema})) {
            Normalizer normalizer = this.factory.getNormalizer((SchemaManager)this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, (SchemaObject)normalizer, schema);
        }
    }

    private void addObjectClasses(Schema schema, Registries registries) throws LdapException, IOException {
        if (schema.getSchemaLoader() == null) {
            return;
        }
        for (Entry entry : schema.getSchemaLoader().loadObjectClasses(new Schema[]{schema})) {
            ObjectClass objectClass = this.factory.getObjectClass(this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, (SchemaObject)objectClass, schema);
        }
    }

    private void addSyntaxes(Schema schema, Registries registries) throws LdapException, IOException {
        if (schema.getSchemaLoader() == null) {
            return;
        }
        for (Entry entry : schema.getSchemaLoader().loadSyntaxes(new Schema[]{schema})) {
            LdapSyntax syntax = this.factory.getSyntax(this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, (SchemaObject)syntax, schema);
        }
    }

    private void addSyntaxCheckers(Schema schema, Registries registries) throws LdapException, IOException {
        if (schema.getSchemaLoader() == null) {
            return;
        }
        for (Entry entry : schema.getSchemaLoader().loadSyntaxCheckers(new Schema[]{schema})) {
            SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker((SchemaManager)this, entry, registries, schema.getSchemaName());
            this.addSchemaObject(registries, (SchemaObject)syntaxChecker, schema);
        }
    }

    private SchemaObject addSchemaObject(Registries registries, SchemaObject schemaObject, Schema schema) throws LdapException {
        if (registries.isRelaxed()) {
            if (registries.isDisabledAccepted() || schema.isEnabled() && schemaObject.isEnabled()) {
                registries.add(schemaObject, false);
            } else {
                this.errorHandler.handle(LOG, null, new Throwable());
            }
        } else if (schema.isEnabled() && schemaObject.isEnabled()) {
            registries.add(schemaObject, false);
        } else {
            this.errorHandler.handle(LOG, null, new Throwable());
        }
        return schemaObject;
    }

    public boolean loadAllEnabled() throws LdapException {
        Schema[] schemas = new Schema[this.schemaMap.size()];
        int i = 0;
        for (Schema schema : this.schemaMap.values()) {
            if (!schema.isEnabled()) continue;
            schemas[i++] = schema;
        }
        Schema[] enabledSchemas = new Schema[i];
        System.arraycopy(schemas, 0, enabledSchemas, 0, i);
        return this.loadWithDeps(enabledSchemas);
    }

    public boolean loadAllEnabledRelaxed() throws LdapException {
        Schema[] enabledSchemas = new Schema[this.schemaMap.size()];
        int i = 0;
        for (Schema schema : this.schemaMap.values()) {
            if (!schema.isEnabled()) continue;
            enabledSchemas[i++] = schema;
        }
        return this.loadWithDepsRelaxed(enabledSchemas);
    }

    public boolean loadDisabled(Schema ... schemas) throws LdapException {
        Registries clonedRegistries = this.cloneRegistries();
        clonedRegistries.setDisabledAccepted(true);
        for (Schema schema : schemas) {
            schema.enable();
            this.load(clonedRegistries, schema);
        }
        clonedRegistries.clear();
        if (!this.errorHandler.wasError()) {
            for (Schema schema : schemas) {
                this.load(this.registries, schema);
            }
            return true;
        }
        for (Schema schema : schemas) {
            schema.disable();
        }
        return false;
    }

    public boolean loadDisabled(String ... schemaNames) throws LdapException {
        Schema[] schemas = this.toArray(schemaNames);
        return this.loadDisabled(schemas);
    }

    public boolean loadRelaxed(Schema ... schemas) throws LdapException {
        return false;
    }

    public boolean loadRelaxed(String ... schemaNames) throws LdapException {
        Schema[] schemas = this.toArray(schemaNames);
        return this.loadRelaxed(schemas);
    }

    public boolean loadWithDeps(Schema ... schemas) throws LdapException {
        boolean loaded = false;
        this.errorHandler.reset();
        Registries clonedRegistries = this.cloneRegistries();
        clonedRegistries.setRelaxed();
        for (Schema schema : schemas) {
            this.loadDepsFirst(clonedRegistries, schema);
        }
        clonedRegistries.buildReferences();
        if (!this.errorHandler.wasError()) {
            clonedRegistries.checkRefInteg();
            if (!this.errorHandler.wasError()) {
                this.registries = clonedRegistries;
                this.registries.setStrict();
                loaded = true;
            }
        } else if (this.isStrict()) {
            clonedRegistries.clear();
        } else {
            this.registries = clonedRegistries;
            this.registries.setRelaxed();
            loaded = true;
        }
        return loaded;
    }

    public boolean loadWithDeps(String ... schemas) throws LdapException {
        return this.loadWithDeps(this.toArray(schemas));
    }

    private void loadDepsFirst(Registries registries, Schema schema) throws LdapException {
        if (schema == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg((I18n)I18n.MSG_16013_SCHEMA_IS_NULL, (Object[])new Object[0]));
            }
            return;
        }
        if (schema.isDisabled() && !registries.isDisabledAccepted()) {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg((I18n)I18n.MSG_16017_UNACCEPTED_DISABLED_SCHEMA, (Object[])new Object[0]));
            }
            return;
        }
        String schemaName = schema.getSchemaName();
        if (registries.isSchemaLoaded(schemaName)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg((I18n)I18n.MSG_16018_SCHEMA_ALREADY_LOADED, (Object[])new Object[]{schema.getSchemaName()}));
            }
            return;
        }
        String[] deps = schema.getDependencies();
        if (deps == null || deps.length == 0) {
            this.load(registries, schema);
            return;
        }
        for (String depName : deps) {
            if (registries.isSchemaLoaded(depName)) continue;
            Schema schemaDep = this.schemaMap.get(depName);
            this.loadDepsFirst(registries, schemaDep);
        }
        this.load(registries, schema);
    }

    public boolean loadWithDepsRelaxed(Schema ... schemas) throws LdapException {
        this.registries.setRelaxed();
        for (Schema schema : schemas) {
            this.loadDepsFirstRelaxed(schema);
        }
        this.registries.buildReferences();
        this.registries.checkRefInteg();
        return true;
    }

    public boolean loadWithDepsRelaxed(String ... schemas) throws LdapException {
        return this.loadWithDepsRelaxed(this.toArray(schemas));
    }

    private void loadDepsFirstRelaxed(Schema schema) throws LdapException {
        if (schema == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg((I18n)I18n.MSG_16013_SCHEMA_IS_NULL, (Object[])new Object[0]));
            }
            return;
        }
        if (schema.isDisabled() && !this.registries.isDisabledAccepted()) {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg((I18n)I18n.MSG_16017_UNACCEPTED_DISABLED_SCHEMA, (Object[])new Object[0]));
            }
            return;
        }
        String schemaName = schema.getSchemaName();
        if (this.registries.isSchemaLoaded(schemaName)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(I18n.msg((I18n)I18n.MSG_16018_SCHEMA_ALREADY_LOADED, (Object[])new Object[]{schema.getSchemaName()}));
            }
            return;
        }
        String[] deps = schema.getDependencies();
        if (deps == null || deps.length == 0) {
            this.load(this.registries, schema);
            return;
        }
        for (String depName : deps) {
            if (this.registries.isSchemaLoaded(schemaName)) continue;
            Schema schemaDep = schema.getSchemaLoader().getSchema(depName);
            this.loadDepsFirstRelaxed(schemaDep);
        }
        this.load(this.registries, schema);
    }

    public void setRegistries(Registries registries) {
        this.registries = registries;
    }

    public boolean unload(Schema ... schemas) throws LdapException {
        boolean unloaded = false;
        this.errorHandler.reset();
        Registries clonedRegistries = this.cloneRegistries();
        clonedRegistries.setRelaxed();
        for (Schema schema : schemas) {
            this.unload(clonedRegistries, schema);
        }
        clonedRegistries.buildReferences();
        if (!this.errorHandler.wasError()) {
            clonedRegistries.checkRefInteg();
            if (!this.errorHandler.wasError()) {
                this.registries.setRelaxed();
                for (Schema schema : schemas) {
                    this.unload(this.registries, schema);
                    for (String dep : schema.getDependencies()) {
                        Set<String> deps = this.schemaDependencies.get(dep);
                        if (deps == null) continue;
                        deps.remove(schema.getSchemaName());
                    }
                    this.schemaMap.remove(schema.getSchemaName());
                }
                this.registries.buildReferences();
                this.registries.setStrict();
                unloaded = true;
            }
        }
        clonedRegistries.clear();
        return unloaded;
    }

    public boolean unload(String ... schemaNames) throws LdapException {
        Schema[] schemas = this.toArray(schemaNames);
        return this.unload(schemas);
    }

    public boolean verify(Schema ... schemas) throws LdapException {
        this.errorHandler.reset();
        Registries clonedRegistries = this.cloneRegistries();
        for (Schema schema : schemas) {
            try {
                boolean loaded = this.load(clonedRegistries, schema);
                if (!loaded) {
                    clonedRegistries.clear();
                    return false;
                }
                clonedRegistries.checkRefInteg();
                if (this.errorHandler.wasError()) continue;
                clonedRegistries.clear();
                return false;
            }
            catch (Exception e) {
                clonedRegistries.clear();
                return false;
            }
        }
        clonedRegistries.clear();
        return true;
    }

    public boolean verify(String ... schemas) throws LdapException {
        return this.verify(this.toArray(schemas));
    }

    public Dn getNamingContext() {
        return this.namingContext;
    }

    public void initialize() throws LdapException {
    }

    public AttributeTypeRegistry getAttributeTypeRegistry() {
        return new ImmutableAttributeTypeRegistry(this.registries.getAttributeTypeRegistry());
    }

    public ComparatorRegistry getComparatorRegistry() {
        return new ImmutableComparatorRegistry(this.registries.getComparatorRegistry());
    }

    public DitContentRuleRegistry getDITContentRuleRegistry() {
        return new ImmutableDitContentRuleRegistry(this.registries.getDitContentRuleRegistry());
    }

    public DitStructureRuleRegistry getDITStructureRuleRegistry() {
        return new ImmutableDitStructureRuleRegistry(this.registries.getDitStructureRuleRegistry());
    }

    public MatchingRuleRegistry getMatchingRuleRegistry() {
        return new ImmutableMatchingRuleRegistry(this.registries.getMatchingRuleRegistry());
    }

    public MatchingRuleUseRegistry getMatchingRuleUseRegistry() {
        return new ImmutableMatchingRuleUseRegistry(this.registries.getMatchingRuleUseRegistry());
    }

    public NameFormRegistry getNameFormRegistry() {
        return new ImmutableNameFormRegistry(this.registries.getNameFormRegistry());
    }

    public NormalizerRegistry getNormalizerRegistry() {
        return new ImmutableNormalizerRegistry(this.registries.getNormalizerRegistry());
    }

    public ObjectClassRegistry getObjectClassRegistry() {
        return new ImmutableObjectClassRegistry(this.registries.getObjectClassRegistry());
    }

    public LdapSyntaxRegistry getLdapSyntaxRegistry() {
        return new ImmutableLdapSyntaxRegistry(this.registries.getLdapSyntaxRegistry());
    }

    public SyntaxCheckerRegistry getSyntaxCheckerRegistry() {
        return new ImmutableSyntaxCheckerRegistry(this.registries.getSyntaxCheckerRegistry());
    }

    private String stripOptions(String oid) {
        int semiColonPos = oid.indexOf(59);
        if (semiColonPos != -1) {
            return oid.substring(0, semiColonPos);
        }
        return oid;
    }

    public AttributeType lookupAttributeTypeRegistry(String oid) throws LdapException {
        String oidTrimmed = Strings.toLowerCaseAscii((String)oid).trim();
        String oidNoOption = this.stripOptions(oidTrimmed);
        return (AttributeType)this.registries.getAttributeTypeRegistry().lookup(oidNoOption);
    }

    public AttributeType getAttributeType(String oid) {
        try {
            String attributeTypeNoOptions = SchemaUtils.stripOptions((String)oid);
            return (AttributeType)this.registries.getAttributeTypeRegistry().lookup(Strings.toLowerCaseAscii((String)attributeTypeNoOptions).trim());
        }
        catch (LdapException lnsae) {
            return null;
        }
    }

    public LdapComparator<?> lookupComparatorRegistry(String oid) throws LdapException {
        return (LdapComparator)this.registries.getComparatorRegistry().lookup(oid);
    }

    public MatchingRule lookupMatchingRuleRegistry(String oid) throws LdapException {
        return (MatchingRule)this.registries.getMatchingRuleRegistry().lookup(Strings.toLowerCaseAscii((String)oid).trim());
    }

    public Normalizer lookupNormalizerRegistry(String oid) throws LdapException {
        return (Normalizer)this.registries.getNormalizerRegistry().lookup(oid);
    }

    public ObjectClass lookupObjectClassRegistry(String oid) throws LdapException {
        return (ObjectClass)this.registries.getObjectClassRegistry().lookup(Strings.toLowerCaseAscii((String)oid).trim());
    }

    public LdapSyntax lookupLdapSyntaxRegistry(String oid) throws LdapException {
        return (LdapSyntax)this.registries.getLdapSyntaxRegistry().lookup(Strings.toLowerCaseAscii((String)oid).trim());
    }

    public SyntaxChecker lookupSyntaxCheckerRegistry(String oid) throws LdapException {
        return (SyntaxChecker)this.registries.getSyntaxCheckerRegistry().lookup(oid);
    }

    private boolean checkOidExist(SchemaObject schemaObject) {
        if (!(schemaObject instanceof LoadableSchemaObject)) {
            return this.registries.getGlobalOidRegistry().contains(schemaObject.getOid());
        }
        if (schemaObject instanceof LdapComparator) {
            return this.registries.getComparatorRegistry().contains(schemaObject.getOid());
        }
        if (schemaObject instanceof SyntaxChecker) {
            return this.registries.getSyntaxCheckerRegistry().contains(schemaObject.getOid());
        }
        if (schemaObject instanceof Normalizer) {
            return this.registries.getNormalizerRegistry().contains(schemaObject.getOid());
        }
        return false;
    }

    private SchemaObject getSchemaObject(SchemaObject schemaObject) throws LdapException {
        if (schemaObject instanceof LoadableSchemaObject) {
            return schemaObject;
        }
        return this.registries.getGlobalOidRegistry().getSchemaObject(schemaObject.getOid());
    }

    private String getSchemaName(SchemaObject schemaObject) {
        String schemaName = Strings.toLowerCaseAscii((String)schemaObject.getSchemaName());
        if (Strings.isEmpty((String)schemaName)) {
            return "other";
        }
        if (this.schemaMap.get(schemaName) == null) {
            return null;
        }
        return schemaName;
    }

    private SchemaObject copy(SchemaObject schemaObject) {
        SchemaObject copy = null;
        if (!(schemaObject instanceof LoadableSchemaObject)) {
            copy = schemaObject.copy();
        } else if (((LoadableSchemaObject)schemaObject).isValid()) {
            copy = schemaObject;
        } else {
            LdapUnwillingToPerformException error = new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((I18n)I18n.ERR_16079_INVALID_SCHEMA_OBJECT_CANNOT_BE_LOADED, (Object[])new Object[]{schemaObject.getOid()}));
            this.errorHandler.handle(LOG, error.getMessage(), (Throwable)error);
        }
        return copy;
    }

    public boolean add(SchemaObject schemaObject) throws LdapException {
        this.errorHandler.reset();
        SchemaObject copy = this.copy(schemaObject);
        if (copy == null) {
            return false;
        }
        if (this.registries.isRelaxed()) {
            this.registries.add(copy, true);
            return !this.errorHandler.wasError();
        }
        if (this.checkOidExist(copy)) {
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OID_ALREADY_REGISTERED, I18n.err((I18n)I18n.ERR_16036_OID_NOT_UNIQUE, (Object[])new Object[]{schemaObject.getOid()}));
            ldapSchemaException.setSourceObject(schemaObject);
            this.errorHandler.handle(LOG, ldapSchemaException.getMessage(), (Throwable)ldapSchemaException);
            return false;
        }
        String schemaName = this.getSchemaName(copy);
        if (schemaName == null) {
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.NONEXISTENT_SCHEMA, I18n.err((I18n)I18n.ERR_16037_NON_EXISTING_SCHEMA, (Object[])new Object[]{schemaObject.getOid(), copy.getSchemaName()}));
            ldapSchemaException.setSourceObject(schemaObject);
            ldapSchemaException.setRelatedId(copy.getSchemaName());
            this.errorHandler.handle(LOG, ldapSchemaException.getMessage(), (Throwable)ldapSchemaException);
            return false;
        }
        Schema schema = this.getLoadedSchema(schemaName);
        if (schema == null) {
            String msg = I18n.err((I18n)I18n.ERR_16038_NOT_ASSOCIATED_TO_A_SCHEMA, (Object[])new Object[]{copy.getOid()});
            LdapProtocolErrorException error = new LdapProtocolErrorException(msg);
            this.errorHandler.handle(LOG, msg, (Throwable)error);
            return false;
        }
        if (schema.isEnabled() && copy.isEnabled()) {
            Registries clonedRegistries = null;
            try {
                clonedRegistries = this.registries.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new LdapOtherException(cnse.getMessage(), (Throwable)cnse);
            }
            clonedRegistries.add(copy, true);
            clonedRegistries.clear();
            if (!this.errorHandler.wasError()) {
                copy = this.copy(schemaObject);
                this.registries.add(copy, true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_16019_ENABLED_SCHEMA_ADDED, (Object[])new Object[]{copy.getName(), schemaName}));
                }
                return true;
            }
            this.errorHandler.handle(LOG, I18n.msg((I18n)I18n.MSG_16020_CANNOT_LOAD_SCHEMAOBJECT, (Object[])new Object[]{copy.getOid(), Strings.listToString((List)this.errorHandler.getErrors())}), null);
            return false;
        }
        this.registries.associateWithSchema(copy);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_16021_ADDED_INTO_DISABLED_SCHEMA, (Object[])new Object[]{copy.getName(), schemaName}));
        }
        return !this.errorHandler.wasError();
    }

    public boolean delete(SchemaObject schemaObject) throws LdapException {
        this.errorHandler.reset();
        if (this.registries.isRelaxed()) {
            this.registries.delete(schemaObject);
            return !this.errorHandler.wasError();
        }
        if (!this.checkOidExist(schemaObject)) {
            LdapProtocolErrorException error = new LdapProtocolErrorException(I18n.err((I18n)I18n.ERR_16039_OID_DOES_NOT_EXIST, (Object[])new Object[]{schemaObject.getOid()}));
            this.errorHandler.handle(LOG, error.getMessage(), (Throwable)error);
            return false;
        }
        SchemaObject toDelete = this.getSchemaObject(schemaObject);
        Set referencing = this.registries.getReferencing(toDelete);
        if (referencing != null && !referencing.isEmpty()) {
            String msg = I18n.err((I18n)I18n.ERR_16040_CANNOT_REMOVE_FROM_REGISTRY, (Object[])new Object[]{schemaObject.getOid(), Strings.setToString((Set)referencing)});
            LdapProtocolErrorException error = new LdapProtocolErrorException(msg);
            this.errorHandler.handle(LOG, msg, (Throwable)error);
            return false;
        }
        String schemaName = this.getSchemaName(toDelete);
        Schema schema = this.getLoadedSchema(schemaName);
        if (schema == null) {
            String msg = I18n.err((I18n)I18n.ERR_16041_CANNOT_DELETE_SCHEMA_OBJECT, (Object[])new Object[]{schemaObject.getOid()});
            LdapProtocolErrorException error = new LdapProtocolErrorException(msg);
            this.errorHandler.handle(LOG, msg, (Throwable)error);
            return false;
        }
        if (schema.isEnabled() && schemaObject.isEnabled()) {
            Registries clonedRegistries = null;
            try {
                clonedRegistries = this.registries.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new LdapOtherException(cnse.getMessage(), (Throwable)cnse);
            }
            clonedRegistries.delete(toDelete);
            clonedRegistries.clear();
            if (!this.errorHandler.wasError()) {
                this.registries.delete(toDelete);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_16022_REMOVED_FROM_ENABLED_SCHEMA, (Object[])new Object[]{toDelete.getName(), schemaName}));
                }
                return true;
            }
            this.errorHandler.handle(LOG, I18n.msg((I18n)I18n.MSG_16023_CANNOT_DELETE_SCHEMAOBJECT, (Object[])new Object[]{schemaObject.getOid(), Strings.listToString((List)this.errorHandler.getErrors())}), null);
            return false;
        }
        this.registries.associateWithSchema(schemaObject);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_16024_REMOVED_FROM_DISABLED_SCHEMA, (Object[])new Object[]{schemaObject.getName(), schemaName}));
        }
        return !this.errorHandler.wasError();
    }

    public Map<String, OidNormalizer> getNormalizerMapping() {
        return this.registries.getAttributeTypeRegistry().getNormalizerMapping();
    }

    public OidRegistry getGlobalOidRegistry() {
        return this.registries.getGlobalOidRegistry();
    }

    public Schema getLoadedSchema(String schemaName) {
        return this.schemaMap.get(schemaName);
    }

    public boolean isSchemaLoaded(String schemaName) {
        try {
            Schema schema = this.schemaMap.get(schemaName);
            return schema != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public SchemaObject unregisterAttributeType(String attributeTypeOid) throws LdapException {
        return this.registries.getAttributeTypeRegistry().unregister(attributeTypeOid);
    }

    public SchemaObject unregisterComparator(String comparatorOid) throws LdapException {
        return this.registries.getComparatorRegistry().unregister(comparatorOid);
    }

    public SchemaObject unregisterDitControlRule(String ditControlRuleOid) throws LdapException {
        return this.registries.getDitContentRuleRegistry().unregister(ditControlRuleOid);
    }

    public SchemaObject unregisterDitStructureRule(String ditStructureRuleOid) throws LdapException {
        return this.registries.getDitStructureRuleRegistry().unregister(ditStructureRuleOid);
    }

    public SchemaObject unregisterLdapSyntax(String ldapSyntaxOid) throws LdapException {
        return this.registries.getLdapSyntaxRegistry().unregister(ldapSyntaxOid);
    }

    public SchemaObject unregisterMatchingRule(String matchingRuleOid) throws LdapException {
        return this.registries.getMatchingRuleRegistry().unregister(matchingRuleOid);
    }

    public SchemaObject unregisterMatchingRuleUse(String matchingRuleUseOid) throws LdapException {
        return this.registries.getMatchingRuleUseRegistry().unregister(matchingRuleUseOid);
    }

    public SchemaObject unregisterNameForm(String nameFormOid) throws LdapException {
        return this.registries.getNameFormRegistry().unregister(nameFormOid);
    }

    public SchemaObject unregisterNormalizer(String normalizerOid) throws LdapException {
        return this.registries.getNormalizerRegistry().unregister(normalizerOid);
    }

    public SchemaObject unregisterObjectClass(String objectClassOid) throws LdapException {
        return this.registries.getObjectClassRegistry().unregister(objectClassOid);
    }

    public SchemaObject unregisterSyntaxChecker(String syntaxCheckerOid) throws LdapException {
        return this.registries.getSyntaxCheckerRegistry().unregister(syntaxCheckerOid);
    }

    public boolean isRelaxed() {
        return this.isRelaxed;
    }

    public boolean isStrict() {
        return !this.isRelaxed;
    }

    public Set<String> listDependentSchemaNames(String schemaName) {
        return this.schemaDependencies.get(schemaName);
    }

    public void setRelaxed() {
        this.isRelaxed = true;
    }

    public void setStrict() {
        this.isRelaxed = false;
    }

    public SchemaErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(SchemaErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.registries.setErrorHandler(errorHandler);
    }

    public boolean isDisabled(String schemaName) {
        Schema schema = this.registries.getLoadedSchema(schemaName);
        return schema != null && schema.isDisabled();
    }

    public boolean isDisabled(Schema schema) {
        return schema != null && schema.isDisabled();
    }

    public boolean isEnabled(String schemaName) {
        Schema schema = this.registries.getLoadedSchema(schemaName);
        return schema != null && schema.isEnabled();
    }

    public boolean isEnabled(Schema schema) {
        return schema != null && schema.isEnabled();
    }
}

