// $ANTLR 2.7.7 (20060906): "distinguishedName.g" -> "AntlrDnParser.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    https://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.api.ldap.model.name;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import javax.naming.NameParser;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.util.ExpansibleByteBuffer;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.Unicode;

public interface AntlrDnTokenTypes {
	int EOF = 1;
	int NULL_TREE_LOOKAHEAD = 3;
	int COMMA = 4;
	int EQUALS = 5;
	int PLUS = 6;
	int HYPHEN = 7;
	int UNDERSCORE = 8;
	int DQUOTE = 9;
	int SEMI = 10;
	int LANGLE = 11;
	int RANGLE = 12;
	int SPACE = 13;
	int NUMERICOID_OR_ALPHA_OR_DIGIT = 14;
	int NUMERICOID = 15;
	int DOT = 16;
	int NUMBER = 17;
	int LDIGIT = 18;
	int DIGIT = 19;
	int ALPHA = 20;
	int HEXPAIR_OR_ESCESC_ESCSHARP_OR_ESC = 21;
	int HEXPAIR = 22;
	int ESC = 23;
	int ESCESC = 24;
	int ESCSHARP = 25;
	int HEX = 26;
	int HEXVALUE_OR_SHARP = 27;
	int HEXVALUE = 28;
	int SHARP = 29;
	int UTFMB = 30;
	int CHAR_REST = 31;
}
