/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class DirectoryStringSyntaxChecker
extends SyntaxChecker {
    public static final DirectoryStringSyntaxChecker INSTANCE = new DirectoryStringSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.15");

    private DirectoryStringSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        for (char c : strValue.toCharArray()) {
            if (c != '\ufffd') continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_04489_SYNTAX_VALID, (Object[])new Object[]{value}));
        }
        return true;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<DirectoryStringSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.15");
        }

        @Override
        public DirectoryStringSyntaxChecker build() {
            return new DirectoryStringSyntaxChecker(this.oid);
        }
    }
}

