/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.ldif.LdapLdifException;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifAttributesReader
extends LdifReader {
    private static final Logger LOG = LoggerFactory.getLogger(LdifAttributesReader.class);

    public LdifAttributesReader() {
        this.lines = new ArrayList();
        this.position = 0;
        this.version = 1;
    }

    private void parseAttribute(Attributes attributes, String line, String lowerLine) throws LdapLdifException {
        int colonIndex = line.indexOf(58);
        String attributeType = lowerLine.substring(0, colonIndex);
        if (attributeType.equals("dn")) {
            LOG.error(I18n.err((I18n)I18n.ERR_12002_ENTRY_WITH_TWO_DNS, (Object[])new Object[0]));
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12003_LDIF_ENTRY_WITH_TWO_DNS, (Object[])new Object[0]));
        }
        Object attributeValue = this.parseValue(line, colonIndex);
        Attribute attribute = attributes.get(attributeType);
        if (attribute == null) {
            attributes.put(attributeType, attributeValue);
        } else {
            attribute.add(attributeValue);
        }
    }

    private void parseEntryAttribute(SchemaManager schemaManager, Entry entry, String line, String lowerLine) throws LdapLdifException {
        int colonIndex = line.indexOf(58);
        String attributeName = lowerLine.substring(0, colonIndex);
        AttributeType attributeType = null;
        if (attributeName.equals("dn")) {
            LOG.error(I18n.err((I18n)I18n.ERR_12002_ENTRY_WITH_TWO_DNS, (Object[])new Object[0]));
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12003_LDIF_ENTRY_WITH_TWO_DNS, (Object[])new Object[0]));
        }
        if (schemaManager != null && (attributeType = schemaManager.getAttributeType(attributeName)) == null) {
            LOG.error("");
            throw new LdapLdifException("");
        }
        Object attributeValue = this.parseValue(line, colonIndex);
        org.apache.directory.api.ldap.model.entry.Attribute attribute = null;
        attribute = schemaManager == null ? entry.get(attributeName) : entry.get(attributeType);
        if (attribute == null) {
            if (schemaManager == null) {
                if (attributeValue instanceof String) {
                    entry.put(attributeName, (String)attributeValue);
                } else {
                    entry.put(attributeName, (byte[][])new byte[][]{(byte[])attributeValue});
                }
            } else {
                try {
                    if (attributeValue instanceof String) {
                        entry.put(attributeName, attributeType, (String)attributeValue);
                    }
                    entry.put(attributeName, attributeType, (byte[][])new byte[][]{(byte[])attributeValue});
                }
                catch (LdapException le) {
                    throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12057_BAD_ATTRIBUTE, (Object[])new Object[0]), le);
                }
            }
        } else {
            try {
                if (attributeValue instanceof String) {
                    attribute.add((String)attributeValue);
                } else {
                    attribute.add(new byte[][]{(byte[])attributeValue});
                }
            }
            catch (LdapInvalidAttributeValueException liave) {
                throw new LdapLdifException(liave.getMessage(), liave);
            }
        }
    }

    private Entry parseEntry(SchemaManager schemaManager) throws LdapLdifException {
        if (this.lines == null || this.lines.size() == 0) {
            LOG.debug("The entry is empty : end of ldif file");
            return null;
        }
        DefaultEntry entry = new DefaultEntry(schemaManager);
        for (String line : this.lines) {
            String lowerLine = Strings.toLowerCaseAscii((String)line);
            if (lowerLine.startsWith("control:")) {
                LOG.error(I18n.err((I18n)I18n.ERR_12004_CHANGE_NOT_ALLOWED, (Object[])new Object[0]));
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12005_NO_CHANGE, (Object[])new Object[0]));
            }
            if (lowerLine.startsWith("changetype:")) {
                LOG.error(I18n.err((I18n)I18n.ERR_12004_CHANGE_NOT_ALLOWED, (Object[])new Object[0]));
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12005_NO_CHANGE, (Object[])new Object[0]));
            }
            if (line.indexOf(58) > 0) {
                this.parseEntryAttribute(schemaManager, entry, line, lowerLine);
                continue;
            }
            LOG.error(I18n.err((I18n)I18n.ERR_12006_EXPECTING_ATTRIBUTE_TYPE, (Object[])new Object[0]));
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12007_BAD_ATTRIBUTE, (Object[])new Object[0]));
        }
        LOG.debug("Read an attributes : {}", (Object)entry);
        return entry;
    }

    private Attributes parseAttributes() throws LdapLdifException {
        if (this.lines == null || this.lines.size() == 0) {
            LOG.debug("The entry is empty : end of ldif file");
            return null;
        }
        BasicAttributes attributes = new BasicAttributes(true);
        for (String line : this.lines) {
            String lowerLine = Strings.toLowerCaseAscii((String)line);
            if (lowerLine.startsWith("control:")) {
                LOG.error(I18n.err((I18n)I18n.ERR_12004_CHANGE_NOT_ALLOWED, (Object[])new Object[0]));
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12005_NO_CHANGE, (Object[])new Object[0]));
            }
            if (lowerLine.startsWith("changetype:")) {
                LOG.error(I18n.err((I18n)I18n.ERR_12004_CHANGE_NOT_ALLOWED, (Object[])new Object[0]));
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12005_NO_CHANGE, (Object[])new Object[0]));
            }
            if (line.indexOf(58) > 0) {
                this.parseAttribute(attributes, line, lowerLine);
                continue;
            }
            LOG.error(I18n.err((I18n)I18n.ERR_12006_EXPECTING_ATTRIBUTE_TYPE, (Object[])new Object[0]));
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12007_BAD_ATTRIBUTE, (Object[])new Object[0]));
        }
        LOG.debug("Read an attributes : {}", (Object)attributes);
        return attributes;
    }

    public Attributes parseAttributes(String ldif) throws LdapLdifException {
        this.lines = new ArrayList();
        this.position = 0;
        LOG.debug("Starts parsing ldif buffer");
        if (Strings.isEmpty((String)ldif)) {
            return new BasicAttributes(true);
        }
        StringReader strIn = new StringReader(ldif);
        this.reader = new BufferedReader(strIn);
        try {
            this.readLines();
            Attributes attributes = this.parseAttributes();
            if (LOG.isDebugEnabled()) {
                if (attributes == null) {
                    LOG.debug("Parsed no entry.");
                } else {
                    LOG.debug("Parsed one entry.");
                }
            }
            Attributes attributes2 = attributes;
            return attributes2;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err((I18n)I18n.ERR_12008_CANNOT_PARSE_LDIF_BUFFER, (Object[])new Object[]{ne.getLocalizedMessage()}));
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12009_ERROR_PARSING_LDIF_BUFFER, (Object[])new Object[0]), ne);
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException ioe) {
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12024_CANNOT_CLOSE_FILE, (Object[])new Object[0]), ioe);
            }
        }
    }

    public Entry parseEntry(String ldif) throws LdapLdifException {
        this.lines = new ArrayList();
        this.position = 0;
        LOG.debug("Starts parsing ldif buffer");
        if (Strings.isEmpty((String)ldif)) {
            return new DefaultEntry();
        }
        StringReader strIn = new StringReader(ldif);
        this.reader = new BufferedReader(strIn);
        try {
            this.readLines();
            Entry entry = this.parseEntry((SchemaManager)null);
            if (LOG.isDebugEnabled()) {
                if (entry == null) {
                    LOG.debug("Parsed no entry.");
                } else {
                    LOG.debug("Parsed one entry.");
                }
            }
            Entry entry2 = entry;
            return entry2;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err((I18n)I18n.ERR_12008_CANNOT_PARSE_LDIF_BUFFER, (Object[])new Object[]{ne.getLocalizedMessage()}));
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12009_ERROR_PARSING_LDIF_BUFFER, (Object[])new Object[0]), ne);
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException ioe) {
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12024_CANNOT_CLOSE_FILE, (Object[])new Object[0]), ioe);
            }
        }
    }

    public Entry parseEntry(SchemaManager schemaManager, String ldif) throws LdapLdifException {
        this.lines = new ArrayList();
        this.position = 0;
        LOG.debug("Starts parsing ldif buffer");
        if (Strings.isEmpty((String)ldif)) {
            return new DefaultEntry(schemaManager);
        }
        StringReader strIn = new StringReader(ldif);
        this.reader = new BufferedReader(strIn);
        try {
            this.readLines();
            Entry entry = this.parseEntry(schemaManager);
            if (LOG.isDebugEnabled()) {
                if (entry == null) {
                    LOG.debug("Parsed no entry.");
                } else {
                    LOG.debug("Parsed one entry.");
                }
            }
            Entry entry2 = entry;
            return entry2;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err((I18n)I18n.ERR_12008_CANNOT_PARSE_LDIF_BUFFER, (Object[])new Object[]{ne.getLocalizedMessage()}));
            throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12009_ERROR_PARSING_LDIF_BUFFER, (Object[])new Object[0]), ne);
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException ioe) {
                throw new LdapLdifException(I18n.err((I18n)I18n.ERR_12024_CANNOT_CLOSE_FILE, (Object[])new Object[0]), ioe);
            }
        }
    }
}

