/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.constants;

public enum LdapSecurityConstants {
    HASH_METHOD_SHA("SHA", "SHA", "sha"),
    HASH_METHOD_SSHA("SSHA", "SHA", "ssha"),
    HASH_METHOD_SHA256("SHA-256", "SHA-256", "sha256"),
    HASH_METHOD_SSHA256("SSHA-256", "SHA-256", "ssha256"),
    HASH_METHOD_SHA384("SHA-384", "SHA-384", "sha384"),
    HASH_METHOD_SSHA384("SSHA-384", "SHA-384", "ssha384"),
    HASH_METHOD_SHA512("SHA-512", "SHA-512", "sha512"),
    HASH_METHOD_SSHA512("SSHA-512", "SHA-512", "ssha512"),
    HASH_METHOD_MD5("MD5", "MD5", "md5"),
    HASH_METHOD_SMD5("SMD5", "MD5", "smd5"),
    HASH_METHOD_CRYPT("CRYPT", "CRYPT", "crypt"),
    HASH_METHOD_PKCS5S2("PKCS5S2", "PBKDF2WithHmacSHA1", "PKCS5S2");

    private String name;
    private String algorithm;
    private String prefix;

    private LdapSecurityConstants(String name, String algorithm, String prefix) {
        this.name = name;
        this.algorithm = algorithm;
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static LdapSecurityConstants getAlgorithm(String algorithm) {
        if (LdapSecurityConstants.HASH_METHOD_SHA.name.equalsIgnoreCase(algorithm) || LdapSecurityConstants.HASH_METHOD_SHA.prefix.equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA;
        }
        if (LdapSecurityConstants.HASH_METHOD_SSHA.name.equalsIgnoreCase(algorithm) || LdapSecurityConstants.HASH_METHOD_SSHA.prefix.equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA;
        }
        if (LdapSecurityConstants.HASH_METHOD_MD5.name.equalsIgnoreCase(algorithm) || LdapSecurityConstants.HASH_METHOD_MD5.prefix.equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_MD5;
        }
        if (LdapSecurityConstants.HASH_METHOD_SMD5.name.equalsIgnoreCase(algorithm) || LdapSecurityConstants.HASH_METHOD_SMD5.prefix.equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SMD5;
        }
        if (LdapSecurityConstants.HASH_METHOD_CRYPT.name.equalsIgnoreCase(algorithm) || LdapSecurityConstants.HASH_METHOD_CRYPT.prefix.equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_CRYPT;
        }
        if (LdapSecurityConstants.HASH_METHOD_SHA256.name.equalsIgnoreCase(algorithm) || LdapSecurityConstants.HASH_METHOD_SHA256.prefix.equalsIgnoreCase(algorithm) || "sha-256".equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA256;
        }
        if (LdapSecurityConstants.HASH_METHOD_SSHA256.name.equalsIgnoreCase(algorithm) || LdapSecurityConstants.HASH_METHOD_SSHA256.prefix.equalsIgnoreCase(algorithm) || "ssha-256".equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA256;
        }
        if (LdapSecurityConstants.HASH_METHOD_SHA384.name.equalsIgnoreCase(algorithm) || LdapSecurityConstants.HASH_METHOD_SHA384.prefix.equalsIgnoreCase(algorithm) || "sha-384".equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA384;
        }
        if (LdapSecurityConstants.HASH_METHOD_SSHA384.name.equalsIgnoreCase(algorithm) || LdapSecurityConstants.HASH_METHOD_SSHA384.prefix.equalsIgnoreCase(algorithm) || "ssha-384".equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA384;
        }
        if (LdapSecurityConstants.HASH_METHOD_SHA512.name.equalsIgnoreCase(algorithm) || LdapSecurityConstants.HASH_METHOD_SHA512.prefix.equalsIgnoreCase(algorithm) || "sha-512".equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SHA512;
        }
        if (LdapSecurityConstants.HASH_METHOD_SSHA512.name.equalsIgnoreCase(algorithm) || LdapSecurityConstants.HASH_METHOD_SSHA512.prefix.equalsIgnoreCase(algorithm) || "ssha-512".equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_SSHA512;
        }
        if (LdapSecurityConstants.HASH_METHOD_PKCS5S2.name.equalsIgnoreCase(algorithm) || LdapSecurityConstants.HASH_METHOD_PKCS5S2.prefix.equalsIgnoreCase(algorithm)) {
            return HASH_METHOD_PKCS5S2;
        }
        return null;
    }
}

