/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif.anonymizer;

import java.util.Random;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.ldif.anonymizer.Anonymizer;

public class StringAnonymizer
implements Anonymizer {
    Random random = new Random(System.currentTimeMillis());

    @Override
    public Attribute anonymize(Attribute attribute) {
        DefaultAttribute result = new DefaultAttribute(attribute.getAttributeType());
        this.random.setSeed(System.nanoTime());
        for (Value value : attribute) {
            if (value instanceof StringValue) {
                String strValue = value.getString();
                int length = strValue.length();
                char[] newValue = new char[length];
                for (int i = 0; i < length; ++i) {
                    newValue[i] = (char)(this.random.nextInt(25) + 65);
                }
                try {
                    result.add(new String(newValue));
                }
                catch (LdapInvalidAttributeValueException e) {}
                continue;
            }
            byte[] byteValue = value.getBytes();
            byte[] newValue = new byte[byteValue.length];
            for (int i = 0; i < byteValue.length; ++i) {
                newValue[i] = (byte)this.random.nextInt();
            }
            try {
                result.add(new byte[][]{newValue});
            }
            catch (LdapInvalidAttributeValueException e) {}
        }
        return result;
    }
}

