/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.controls;

import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.ldap.model.message.controls.PersistentSearch;

public class PersistentSearchImpl
extends AbstractControl
implements PersistentSearch {
    private boolean changesOnly = true;
    private boolean returnECs = false;
    private int changeTypes = CHANGE_TYPES_MAX;

    public PersistentSearchImpl() {
        super("2.16.840.1.113730.3.4.3");
    }

    public void setChangesOnly(boolean changesOnly) {
        this.changesOnly = changesOnly;
    }

    public boolean isChangesOnly() {
        return this.changesOnly;
    }

    public void setReturnECs(boolean returnECs) {
        this.returnECs = returnECs;
    }

    public boolean isReturnECs() {
        return this.returnECs;
    }

    public void setChangeTypes(int changeTypes) {
        this.changeTypes = changeTypes;
    }

    public int getChangeTypes() {
        return this.changeTypes;
    }

    public boolean isNotificationEnabled(ChangeType changeType) {
        return (changeType.getValue() & this.changeTypes) > 0;
    }

    public void enableNotification(ChangeType changeType) {
        this.changeTypes |= changeType.getValue();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Persistant Search Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        changeTypes : '").append(this.changeTypes).append("'\n");
        sb.append("        changesOnly : '").append(this.changesOnly).append("'\n");
        sb.append("        returnECs   : '").append(this.returnECs).append("'\n");
        return sb.toString();
    }
}

