/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.ldif.anonymizer.Anonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.BinaryAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.IntegerAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.StringAnonymizer;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;

public class LdifAnonymizer {
    Map<AttributeType, Anonymizer> attributeAnonymizers = new HashMap<AttributeType, Anonymizer>();
    SchemaManager schemaManager;
    private static final String CONFIG_FILE_OPT = "f";
    private static String configFile;

    public LdifAnonymizer() {
        try {
            this.schemaManager = new DefaultSchemaManager();
        }
        catch (Exception e) {
            System.out.println("Missing a SchemaManager !");
            System.exit(-1);
        }
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("carLicense"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("cn"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("description"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("displayName"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("gecos"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("gidNumber"), (Anonymizer)new IntegerAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("givenName"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("homeDirectory"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("homePhone"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("homePostalAddress"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("host"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("houseIdentifier"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("jpegPhoto"), (Anonymizer)new BinaryAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("labeledURI"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("localityName"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("mail"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("manager"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("memberUid"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("mobile"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("organizationName"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("organizationalUnitName"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("pager"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("postalAddress"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("photo"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("secretary"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("seeAlso"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("sn"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("telephoneNumber"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("uid"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("uidNumber"), (Anonymizer)new IntegerAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("userCertificate"), (Anonymizer)new StringAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("userPassword"), (Anonymizer)new BinaryAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("userPKCS12"), (Anonymizer)new BinaryAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("userSMIMECertificate"), (Anonymizer)new BinaryAnonymizer());
        this.attributeAnonymizers.put(this.schemaManager.getAttributeType("x500UniqueIdentifier"), (Anonymizer)new BinaryAnonymizer());
    }

    public LdifAnonymizer(Map<String, Anonymizer> attributeAnonymizers) {
        for (String string : attributeAnonymizers.keySet()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String anonymize(String ldif) throws LdapException, IOException {
        LdifReader ldifReader = new LdifReader(this.schemaManager);
        try {
            List entries = ldifReader.parseLdif(ldif);
            StringBuilder result = new StringBuilder();
            for (LdifEntry ldifEntry : entries) {
                Entry entry = ldifEntry.getEntry();
                DefaultEntry newEntry = new DefaultEntry(this.schemaManager);
                Dn dn = entry.getDn();
                Rdn rdns = dn.getRdn();
                ArrayList<Attribute> rdnAttributes = new ArrayList<Attribute>();
                ArrayList<Ava> avas = new ArrayList<Ava>();
                boolean dnAnonymized = false;
                for (Ava ava : rdns) {
                    Anonymizer anonymizer;
                    Attribute rdnAttribute = entry.get(ava.getType());
                    DefaultAttribute newRdnAttribute = new DefaultAttribute(rdnAttribute.getUpId(), rdnAttribute.getAttributeType());
                    newRdnAttribute.add(new Value[]{rdnAttribute.get()});
                    rdnAttribute.remove(new Value[]{rdnAttribute.get()});
                    if (rdnAttribute.size() == 0) {
                        entry.remove(new Attribute[]{rdnAttribute});
                    }
                    if ((anonymizer = this.attributeAnonymizers.get(rdnAttribute.getAttributeType())) != null) {
                        Attribute anonymizedAttribute = anonymizer.anonymize((Attribute)newRdnAttribute);
                        dnAnonymized = true;
                        rdnAttributes.add(anonymizedAttribute);
                        if (anonymizedAttribute.isHumanReadable()) {
                            avas.add(new Ava(this.schemaManager, rdnAttribute.getUpId(), anonymizedAttribute.getString()));
                            continue;
                        }
                        avas.add(new Ava(this.schemaManager, rdnAttribute.getUpId(), anonymizedAttribute.getBytes()));
                        continue;
                    }
                    avas.add(ava);
                }
                if (dnAnonymized) {
                    Rdn newRdn = new Rdn(this.schemaManager, avas.toArray(new Ava[0]));
                    dn = new Dn(newRdn, dn.getParent());
                }
                for (Attribute attribute : entry) {
                    Anonymizer anonymizer = this.attributeAnonymizers.get(attribute.getAttributeType());
                    if (anonymizer == null) {
                        newEntry.add(new Attribute[]{attribute});
                        continue;
                    }
                    Attribute anonymizedAttribute = anonymizer.anonymize(attribute);
                    newEntry.add(new Attribute[]{anonymizedAttribute});
                }
                for (Attribute rdnAttribute : rdnAttributes) {
                    Attribute attribute = newEntry.get(rdnAttribute.getAttributeType());
                    if (attribute == null) {
                        newEntry.add(new Attribute[]{rdnAttribute});
                        continue;
                    }
                    for (Value value : rdnAttribute) {
                        attribute.add(new Value[]{value});
                    }
                }
                newEntry.setDn(dn);
                result.append(LdifUtils.convertToLdif((Entry)newEntry));
                result.append("\n");
            }
            String string = result.toString();
            return string;
        }
        finally {
            ldifReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, LdapException {
        if (args == null || args.length < 1) {
            System.out.println("No file to anonymize");
        }
        LdifAnonymizer anonymizer = new LdifAnonymizer();
        BufferedReader br = new BufferedReader(new FileReader(args[0]));
        String ldifString = null;
        try {
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            ldifString = sb.toString();
        }
        finally {
            br.close();
        }
        String result = anonymizer.anonymize(ldifString);
        System.out.println(result);
    }
}

