/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Serialize;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ava
implements Externalizable,
Cloneable,
Comparable<Ava> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Ava.class);
    private String normType;
    private String upType;
    private Value value;
    private String upName;
    private AttributeType attributeType;
    private transient SchemaManager schemaManager;
    private volatile int h;

    public Ava() {
        this(null);
    }

    public Ava(SchemaManager schemaManager) {
        this.normType = null;
        this.upType = null;
        this.value = null;
        this.upName = "";
        this.schemaManager = schemaManager;
        this.attributeType = null;
    }

    public Ava(SchemaManager schemaManager, Ava ava) throws LdapInvalidDnException {
        this.upType = ava.upType;
        if (ava.isSchemaAware()) {
            this.normType = ava.normType;
            this.value = ava.value;
            this.attributeType = ava.getAttributeType();
        } else if (schemaManager != null) {
            this.attributeType = schemaManager.getAttributeType(ava.normType);
            if (this.attributeType != null) {
                this.normType = this.attributeType.getOid();
                try {
                    this.value = new Value(this.attributeType, ava.value);
                }
                catch (LdapInvalidAttributeValueException e) {
                    throw new LdapInvalidDnException(e.getResultCode());
                }
            } else {
                this.normType = ava.normType;
                this.value = ava.value;
            }
        } else {
            this.normType = ava.normType;
            this.value = ava.value;
        }
        this.upName = this.getEscaped();
        this.hashCode();
    }

    public Ava(String upType, byte[] upValue) throws LdapInvalidDnException {
        this(null, upType, upValue);
    }

    public Ava(SchemaManager schemaManager, String upType, byte[] upValue) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err(I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            try {
                this.createAva(schemaManager, upType, new Value(this.attributeType, upValue));
            }
            catch (LdapInvalidAttributeValueException liave) {
                String message = I18n.err(I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, liave);
            }
        }
        this.createAva(upType, new Value(upValue));
    }

    public Ava(SchemaManager schemaManager, String upType, String upName, byte[] upValue) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err(I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            try {
                this.createAva(schemaManager, upType, new Value(this.attributeType, upValue));
            }
            catch (LdapInvalidAttributeValueException liave) {
                String message = I18n.err(I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, liave);
            }
        }
        this.createAva(upType, new Value(upValue));
        this.upName = upName;
    }

    public Ava(String upType, String upValue) throws LdapInvalidDnException {
        this(null, upType, upValue);
    }

    public Ava(SchemaManager schemaManager, String upType, String upValue) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err(I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            try {
                this.createAva(schemaManager, upType, new Value(this.attributeType, upValue));
            }
            catch (LdapInvalidAttributeValueException liave) {
                String message = I18n.err(I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, liave);
            }
        }
        this.createAva(upType, new Value(upValue));
    }

    public Ava(SchemaManager schemaManager, String upType, String upName, String upValue) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            try {
                this.attributeType = schemaManager.lookupAttributeTypeRegistry(upType);
            }
            catch (LdapException le) {
                String message = I18n.err(I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            try {
                this.createAva(schemaManager, upType, new Value(this.attributeType, upValue));
            }
            catch (LdapInvalidAttributeValueException liave) {
                String message = I18n.err(I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, liave);
            }
        }
        this.createAva(upType, new Value(upValue));
        this.upName = upName;
    }

    Ava(String upType, String normType, Value value, String upName) throws LdapInvalidDnException {
        this(null, upType, normType, value, upName);
    }

    Ava(AttributeType attributeType, String upType, String normType, Value value, String upName) throws LdapInvalidDnException {
        this.attributeType = attributeType;
        String upTypeTrimmed = Strings.trim(upType);
        String normTypeTrimmed = Strings.trim(normType);
        if (Strings.isEmpty(upTypeTrimmed)) {
            if (Strings.isEmpty(normTypeTrimmed)) {
                String message = I18n.err(I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, new Object[0]);
                LOG.error(message);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message);
            }
            this.normType = Strings.lowerCaseAscii(normTypeTrimmed);
            this.upType = normType;
        } else if (Strings.isEmpty(normTypeTrimmed)) {
            this.normType = Strings.lowerCaseAscii(upTypeTrimmed);
            this.upType = upType;
        } else {
            this.normType = Strings.lowerCaseAscii(normTypeTrimmed);
            this.upType = upType;
        }
        this.value = value;
        this.upName = upName;
        this.hashCode();
    }

    Ava(SchemaManager schemaManager, String upType, String normType, Value value) throws LdapInvalidDnException {
        StringBuilder sb = new StringBuilder();
        this.upType = upType;
        this.normType = normType;
        this.value = value;
        sb.append(upType);
        sb.append('=');
        if (value != null && value.getString() != null) {
            sb.append(value.getString());
        }
        this.upName = sb.toString();
        if (schemaManager != null) {
            this.apply(schemaManager);
        }
        this.hashCode();
    }

    private void createAva(SchemaManager schemaManager, String upType, Value value) {
        StringBuilder sb = new StringBuilder();
        this.normType = this.attributeType.getOid();
        this.upType = upType;
        this.value = value;
        sb.append(upType);
        sb.append('=');
        if (value != null) {
            sb.append(Rdn.escapeValue(value.getString()));
        }
        this.upName = sb.toString();
        this.hashCode();
    }

    private void createAva(String upType, Value upValue) throws LdapInvalidDnException {
        String upTypeTrimmed = Strings.trim(upType);
        String normTypeTrimmed = Strings.trim(this.normType);
        if (Strings.isEmpty(upTypeTrimmed)) {
            if (Strings.isEmpty(normTypeTrimmed)) {
                String message = I18n.err(I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message);
            }
            this.upType = this.normType = Strings.lowerCaseAscii(normTypeTrimmed);
        } else if (Strings.isEmpty(normTypeTrimmed)) {
            this.normType = Strings.lowerCaseAscii(upTypeTrimmed);
            this.upType = upType;
        } else {
            this.normType = Strings.lowerCaseAscii(normTypeTrimmed);
            this.upType = upType;
        }
        this.value = upValue;
        this.upName = this.getEscaped();
        this.hashCode();
    }

    private void apply(SchemaManager schemaManager) throws LdapInvalidDnException {
        if (schemaManager != null) {
            this.schemaManager = schemaManager;
            AttributeType tmpAttributeType = null;
            try {
                tmpAttributeType = schemaManager.lookupAttributeTypeRegistry(this.normType);
            }
            catch (LdapException le) {
                if (schemaManager.isRelaxed()) {
                    return;
                }
                String message = I18n.err(I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            if (this.attributeType == tmpAttributeType) {
                return;
            }
            this.attributeType = tmpAttributeType;
            try {
                this.value = new Value(tmpAttributeType, this.value);
            }
            catch (LdapException le) {
                String message = I18n.err(I18n.ERR_13600_TYPE_IS_NULL_OR_EMPTY, new Object[0]);
                throw new LdapInvalidDnException(ResultCodeEnum.INVALID_DN_SYNTAX, message, le);
            }
            this.hashCode();
        }
    }

    public String getNormType() {
        return this.normType;
    }

    public String getType() {
        return this.upType;
    }

    public Value getValue() {
        return this.value.clone();
    }

    public String getName() {
        return this.upName;
    }

    public String getEscaped() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType());
        sb.append('=');
        if (this.value == null) {
            return sb.toString();
        }
        byte[] bytes = this.value.getBytes();
        if (Strings.isEmpty(bytes)) {
            return sb.toString();
        }
        boolean leadChar = true;
        for (int pos = 0; pos < bytes.length; ++pos) {
            boolean trailChar = pos == bytes.length - 1;
            byte b = bytes[pos];
            switch (b) {
                case 0: {
                    sb.append("\\00");
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    sb.append((char)b);
                    break;
                }
                case 32: {
                    if (leadChar || trailChar) {
                        sb.append("\\ ");
                        break;
                    }
                    sb.append((char)b);
                    break;
                }
                case 33: {
                    sb.append((char)b);
                    break;
                }
                case 34: {
                    sb.append("\\\"");
                    break;
                }
                case 35: {
                    if (leadChar) {
                        sb.append("\\#");
                        break;
                    }
                    sb.append('#');
                    break;
                }
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    sb.append((char)b);
                    break;
                }
                case 43: {
                    sb.append("\\+");
                    break;
                }
                case 44: {
                    sb.append("\\,");
                    break;
                }
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    sb.append((char)b);
                    break;
                }
                case 59: {
                    sb.append("\\;");
                    break;
                }
                case 60: {
                    sb.append("\\<");
                    break;
                }
                case 61: {
                    sb.append((char)b);
                    break;
                }
                case 62: {
                    sb.append("\\>");
                    break;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: {
                    sb.append((char)b);
                    break;
                }
                case 92: {
                    sb.append("\\\\");
                    break;
                }
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    sb.append((char)b);
                    break;
                }
                case -128: 
                case -127: 
                case -126: 
                case -125: 
                case -124: 
                case -123: 
                case -122: 
                case -121: 
                case -120: 
                case -119: 
                case -118: 
                case -117: 
                case -116: 
                case -115: 
                case -114: 
                case -113: 
                case -112: 
                case -111: 
                case -110: 
                case -109: 
                case -108: 
                case -107: 
                case -106: 
                case -105: 
                case -104: 
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: 
                case -89: 
                case -88: 
                case -87: 
                case -86: 
                case -85: 
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: 
                case -78: 
                case -77: 
                case -76: 
                case -75: 
                case -74: 
                case -73: 
                case -72: 
                case -71: 
                case -70: 
                case -69: 
                case -68: 
                case -67: 
                case -66: 
                case -65: 
                case -64: 
                case -63: {
                    sb.append('\\').append(Strings.byteToString(b));
                    break;
                }
                case -62: 
                case -61: 
                case -60: 
                case -59: 
                case -58: 
                case -57: 
                case -56: 
                case -55: 
                case -54: 
                case -53: 
                case -52: 
                case -51: 
                case -50: 
                case -49: 
                case -48: 
                case -47: 
                case -46: 
                case -45: 
                case -44: 
                case -43: 
                case -42: 
                case -41: 
                case -40: 
                case -39: 
                case -38: 
                case -37: 
                case -36: 
                case -35: 
                case -34: 
                case -33: {
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = bytes[pos + 1] & 0xFF;
                    if (b2 >= 128 && b2 <= 191) {
                        sb.append(Strings.utf8ToString(bytes, pos, 2));
                        ++pos;
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    break;
                }
                case -32: {
                    int b3;
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    if (pos == bytes.length - 2) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = bytes[pos + 1] & 0xFF;
                    if (b2 >= 160 && b2 <= 191) {
                        b3 = bytes[pos + 2] & 0xFF;
                        if (b3 >= 128 && b3 <= 191) {
                            sb.append(Strings.utf8ToString(bytes, pos, 3));
                            pos += 2;
                            break;
                        }
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    break;
                }
                case -31: 
                case -30: 
                case -29: 
                case -28: 
                case -27: 
                case -26: 
                case -25: 
                case -24: 
                case -23: 
                case -22: 
                case -21: 
                case -20: 
                case -18: 
                case -17: {
                    int b3;
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    if (pos == bytes.length - 2) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = bytes[pos + 1] & 0xFF;
                    if (b2 >= 128 && b2 <= 191) {
                        b3 = bytes[pos + 2] & 0xFF;
                        if (b3 >= 128 && b3 <= 191) {
                            sb.append(Strings.utf8ToString(bytes, pos, 3));
                            pos += 2;
                            break;
                        }
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    ++pos;
                    break;
                }
                case -19: {
                    int b3;
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    if (pos == bytes.length - 2) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = bytes[pos + 1] & 0xFF;
                    if (b2 >= 128 && b2 <= 159) {
                        b3 = bytes[pos + 2] & 0xFF;
                        if (b3 >= 128 && b3 <= 191) {
                            sb.append(Strings.utf8ToString(bytes, pos, 3));
                            pos += 2;
                            break;
                        }
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    ++pos;
                    break;
                }
                case -16: {
                    int b4;
                    int b3;
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    if (pos == bytes.length - 3) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = bytes[pos + 1] & 0xFF;
                    if (b2 >= 144 && b2 <= 191) {
                        b3 = bytes[pos + 2] & 0xFF;
                        if (b3 >= 128 && b3 <= 191) {
                            b4 = bytes[pos + 3] & 0xFF;
                            if (b4 >= 128 && b4 <= 191) {
                                sb.append(Strings.utf8ToString(bytes, pos, 4));
                                pos += 3;
                                break;
                            }
                            sb.append('\\').append(Strings.byteToString(b));
                            break;
                        }
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    ++pos;
                    break;
                }
                case -15: 
                case -14: 
                case -13: {
                    int b4;
                    int b3;
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    if (pos == bytes.length - 3) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = bytes[pos + 1] & 0xFF;
                    if (b2 >= 128 && b2 <= 191) {
                        b3 = bytes[pos + 2] & 0xFF;
                        if (b3 >= 128 && b3 <= 191) {
                            b4 = bytes[pos + 3] & 0xFF;
                            if (b4 >= 128 && b4 <= 191) {
                                sb.append(Strings.utf8ToString(bytes, pos, 4));
                                pos += 3;
                                break;
                            }
                            sb.append('\\').append(Strings.byteToString(b));
                            break;
                        }
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    ++pos;
                    break;
                }
                case -12: {
                    int b4;
                    int b3;
                    if (trailChar) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    if (pos == bytes.length - 3) {
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    int b2 = bytes[pos + 1] & 0xFF;
                    if (b2 >= 128 && b2 <= 143) {
                        b3 = bytes[pos + 2] & 0xFF;
                        if (b3 >= 128 && b3 <= 191) {
                            b4 = bytes[pos + 3] & 0xFF;
                            if (b4 >= 128 && b4 <= 191) {
                                sb.append(Strings.utf8ToString(bytes, pos, 4));
                                pos += 3;
                                break;
                            }
                            sb.append('\\').append(Strings.byteToString(b));
                            break;
                        }
                        sb.append('\\').append(Strings.byteToString(b));
                        break;
                    }
                    sb.append('\\').append(Strings.byteToString(b));
                    ++pos;
                    break;
                }
                default: {
                    sb.append('\\').append(Strings.byteToString(b));
                }
            }
            if (!leadChar) continue;
            leadChar = false;
        }
        return sb.toString();
    }

    public Ava clone() {
        try {
            Ava clone = (Ava)super.clone();
            clone.value = this.value.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error(I18n.err(I18n.ERR_13621_ASSERTION_FAILURE, new Object[0]), cnse);
        }
    }

    public int hashCode() {
        if (this.h == 0) {
            int hTmp = 37;
            hTmp = hTmp * 17 + (this.normType != null ? this.normType.hashCode() : 0);
            this.h = hTmp * 17 + (this.value != null ? this.value.hashCode() : 0);
        }
        return this.h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Ava)) {
            return false;
        }
        Ava instance = (Ava)obj;
        if (this.attributeType == null ? (this.normType == null ? instance.normType != null : !this.normType.equals(instance.normType)) : (instance.getAttributeType() == null ? this.schemaManager != null && !this.attributeType.equals(this.schemaManager.getAttributeType(instance.getType())) : !this.attributeType.equals(instance.getAttributeType()))) {
            return false;
        }
        if (this.value == null || this.value.isNull()) {
            return instance.value == null || instance.value.isNull();
        }
        if (this.schemaManager != null) {
            MatchingRule equalityMatchingRule;
            if (this.value.getString() != null && this.value.getString().equals(instance.value.getString())) {
                return true;
            }
            if (this.attributeType == null) {
                this.attributeType = this.schemaManager.getAttributeType(this.normType);
            }
            if ((equalityMatchingRule = this.attributeType.getEquality()) != null) {
                Normalizer normalizer = equalityMatchingRule.getNormalizer();
                try {
                    return equalityMatchingRule.getLdapComparator().compare(normalizer.normalize(this.value.getString()), instance.value.getString()) == 0;
                }
                catch (LdapException le) {
                    LOG.error(I18n.err(I18n.ERR_13620_CANNOT_NORMALIZE_VALUE, new Object[0]), (Object)le.getMessage());
                    return false;
                }
            }
            if (!this.value.isHumanReadable()) {
                return Arrays.equals(this.value.getBytes(), instance.value.getBytes());
            }
            return this.value.getString().equals(instance.value.getString());
        }
        return this.value.equals(instance.value);
    }

    public int serialize(byte[] buffer, int pos) throws IOException {
        if (Strings.isEmpty(this.upName) || Strings.isEmpty(this.upType) || Strings.isEmpty(this.normType) || this.value.isNull()) {
            String message = Strings.isEmpty(this.upName) ? I18n.err(I18n.ERR_13616_CANNOT_SERIALIZE_AVA_UPNAME_NULL, new Object[0]) : (Strings.isEmpty(this.upType) ? I18n.err(I18n.ERR_13617_CANNOT_SERIALIZE_AVA_UPTYPE_NULL, new Object[0]) : (Strings.isEmpty(this.normType) ? I18n.err(I18n.ERR_13618_CANNOT_SERIALIZE_AVA_NORMTYPE_NULL, new Object[0]) : I18n.err(I18n.ERR_13619_CANNOT_SERIALIZE_AVA_VALUE_NULL, new Object[0])));
            LOG.error(message);
            throw new IOException(message);
        }
        int length = 0;
        byte[] upNameBytes = null;
        if (this.upName != null) {
            upNameBytes = Strings.getBytesUtf8(this.upName);
            length += 5 + upNameBytes.length;
        }
        byte[] upTypeBytes = null;
        if (this.upType != null) {
            upTypeBytes = Strings.getBytesUtf8(this.upType);
            length += 5 + upTypeBytes.length;
        }
        ++length;
        if (buffer.length - pos < (length += 4)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.upName != null) {
            buffer[pos++] = 1;
            pos = Serialize.serialize(upNameBytes, buffer, pos);
        } else {
            buffer[pos++] = 0;
        }
        if (this.upType != null) {
            buffer[pos++] = 1;
            pos = Serialize.serialize(upTypeBytes, buffer, pos);
        } else {
            buffer[pos++] = 0;
        }
        buffer[pos++] = this.value.isHumanReadable() ? (byte)1 : 0;
        if (this.value.isHumanReadable()) {
            pos = this.value.serialize(buffer, pos);
        }
        pos = Serialize.serialize(this.h, buffer, pos);
        return pos;
    }

    public int deserialize(byte[] buffer, int pos) throws IOException, LdapInvalidAttributeValueException {
        if (pos < 0 || pos >= buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        boolean hasUpName = Serialize.deserializeBoolean(buffer, pos);
        ++pos;
        if (hasUpName) {
            byte[] wrappedValueBytes = Serialize.deserializeBytes(buffer, pos);
            pos += 4 + wrappedValueBytes.length;
            this.upName = Strings.utf8ToString(wrappedValueBytes);
        }
        boolean hasUpType = Serialize.deserializeBoolean(buffer, pos);
        ++pos;
        if (hasUpType) {
            byte[] upTypeBytes = Serialize.deserializeBytes(buffer, pos);
            pos += 4 + upTypeBytes.length;
            this.upType = Strings.utf8ToString(upTypeBytes);
        }
        if (this.schemaManager != null) {
            this.attributeType = !Strings.isEmpty(this.upType) ? this.schemaManager.getAttributeType(this.upType) : this.schemaManager.getAttributeType(this.normType);
        }
        this.normType = this.attributeType != null ? this.attributeType.getOid() : this.upType;
        boolean isHR = Serialize.deserializeBoolean(buffer, pos);
        ++pos;
        if (isHR) {
            this.value = Value.createValue(this.attributeType);
            pos = this.value.deserialize(buffer, pos);
        }
        this.h = Serialize.deserializeInt(buffer, pos);
        return pos += 4;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (Strings.isEmpty(this.upName) || Strings.isEmpty(this.upType) || Strings.isEmpty(this.normType) || this.value.isNull()) {
            String message = Strings.isEmpty(this.upName) ? I18n.err(I18n.ERR_13616_CANNOT_SERIALIZE_AVA_UPNAME_NULL, new Object[0]) : (Strings.isEmpty(this.upType) ? I18n.err(I18n.ERR_13617_CANNOT_SERIALIZE_AVA_UPTYPE_NULL, new Object[0]) : (Strings.isEmpty(this.normType) ? I18n.err(I18n.ERR_13618_CANNOT_SERIALIZE_AVA_NORMTYPE_NULL, new Object[0]) : I18n.err(I18n.ERR_13619_CANNOT_SERIALIZE_AVA_VALUE_NULL, new Object[0])));
            LOG.error(message);
            throw new IOException(message);
        }
        if (this.upName != null) {
            out.writeBoolean(true);
            out.writeUTF(this.upName);
        } else {
            out.writeBoolean(false);
        }
        if (this.upType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.upType);
        } else {
            out.writeBoolean(false);
        }
        if (this.normType != null) {
            out.writeBoolean(true);
            out.writeUTF(this.normType);
        } else {
            out.writeBoolean(false);
        }
        boolean isHR = this.value.isHumanReadable();
        out.writeBoolean(isHR);
        this.value.writeExternal(out);
        out.writeInt(this.h);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean hasNormType;
        boolean hasUpType;
        boolean hasUpName = in.readBoolean();
        if (hasUpName) {
            this.upName = in.readUTF();
        }
        if (hasUpType = in.readBoolean()) {
            this.upType = in.readUTF();
        }
        if (hasNormType = in.readBoolean()) {
            this.normType = in.readUTF();
        }
        if (this.schemaManager != null) {
            this.attributeType = !Strings.isEmpty(this.upType) ? this.schemaManager.getAttributeType(this.upType) : this.schemaManager.getAttributeType(this.normType);
        }
        in.readBoolean();
        this.value = Value.deserialize(this.attributeType, in);
        this.h = in.readInt();
    }

    public boolean isSchemaAware() {
        return this.attributeType != null;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    private int compareValues(Ava that) {
        if (this.value.isHumanReadable()) {
            int comp = this.value.compareTo(that.value);
            return comp;
        }
        byte[] bytes1 = this.value.getBytes();
        byte[] bytes2 = that.value.getBytes();
        for (int pos = 0; pos < bytes1.length; ++pos) {
            int v1 = bytes1[pos] & 0xFF;
            int v2 = bytes2[pos] & 0xFF;
            if (v1 > v2) {
                return 1;
            }
            if (v2 <= v1) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public int compareTo(Ava that) {
        int comp;
        if (that == null) {
            return 1;
        }
        if (this.schemaManager == null) {
            int comp2 = this.normType.compareTo(that.normType);
            if (comp2 != 0) {
                return comp2;
            }
            if (this.value == null) {
                if (that.value == null) {
                    return 0;
                }
                return -1;
            }
            if (that.value == null) {
                return 1;
            }
            comp2 = this.value.compareTo(that.value);
            return comp2;
        }
        if (that.schemaManager == null) {
            try {
                that.apply(this.schemaManager);
            }
            catch (LdapInvalidDnException lide) {
                return 1;
            }
        }
        if ((comp = this.attributeType.getOid().compareTo(that.attributeType.getOid())) != 0) {
            return comp;
        }
        MatchingRule orderingMR = this.attributeType.getOrdering();
        if (orderingMR != null) {
            LdapComparator<? super Object> comparator = orderingMR.getLdapComparator();
            if (comparator != null) {
                comp = this.value.compareTo(that.value);
                return comp;
            }
            comp = this.compareValues(that);
            return comp;
        }
        comp = this.compareValues(that);
        return comp;
    }

    public String toString() {
        return this.upName;
    }
}

