/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schema.extractor.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.directory.api.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceMap {
    private static final String SCHEMA_RESOURCE_LOCATION = "schema.resource.location";
    private static final Logger LOG = LoggerFactory.getLogger(ResourceMap.class);

    private ResourceMap() {
    }

    public static Map<String, Boolean> getResources(Pattern pattern) {
        HashMap<String, Boolean> retval = new HashMap<String, Boolean>();
        String schemaResourceLoc = System.getProperty(SCHEMA_RESOURCE_LOCATION, "");
        if (schemaResourceLoc.trim().length() > 0) {
            File file;
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_16008_LOADING_FROM_USER_SCHEMA, schemaResourceLoc));
            }
            if ((file = new File(schemaResourceLoc)).exists()) {
                ResourceMap.getResources(retval, schemaResourceLoc, pattern);
            } else {
                LOG.error(I18n.err(I18n.ERR_16043_CANOT_LOAD_SCHEMA, schemaResourceLoc));
            }
        } else {
            ResourceMap.getResourcesFromClassloader(retval, pattern);
        }
        return retval;
    }

    private static void getResources(HashMap<String, Boolean> map, String element, Pattern pattern) {
        File file = new File(element);
        if (!file.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_16009_ELEMENT_DOES_NOT_EXIST, element));
            }
            return;
        }
        if (file.isDirectory()) {
            ResourceMap.getResourcesFromDirectory(map, file, pattern);
        } else {
            ResourceMap.getResourcesFromJarFile(map, file, pattern);
        }
    }

    private static void getResourcesFromJarFile(HashMap<String, Boolean> map, File file, Pattern pattern) {
        ZipFile zf;
        try {
            zf = new ZipFile(file);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            map.put(fileName, Boolean.TRUE);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
    }

    private static void getResourcesFromDirectory(HashMap<String, Boolean> map, File directory, Pattern pattern) {
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isDirectory()) {
                    ResourceMap.getResourcesFromDirectory(map, file, pattern);
                    continue;
                }
                try {
                    String fileName = file.getCanonicalPath();
                    boolean accept = pattern.matcher(fileName).matches();
                    if (!accept) continue;
                    map.put(fileName, Boolean.FALSE);
                }
                catch (IOException e) {
                    LOG.error(I18n.err(I18n.ERR_16044_CANNOT_LOAD_FILE, file.getAbsolutePath(), e.getMessage()));
                }
            }
        }
    }

    private static void getResourcesFromClassloader(HashMap<String, Boolean> map, Pattern pattern) {
        try {
            ClassLoader cl = ResourceMap.class.getClassLoader();
            Enumeration<URL> indexes = cl.getResources("META-INF/apacheds-schema.index");
            while (indexes.hasMoreElements()) {
                URL index = null;
                try {
                    index = indexes.nextElement();
                    InputStream in = index.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                    String line = reader.readLine();
                    while (line != null) {
                        boolean accept = pattern.matcher(line).matches();
                        if (accept) {
                            map.put(line, Boolean.TRUE);
                        }
                        line = reader.readLine();
                    }
                    reader.close();
                }
                catch (IOException ioe) {
                    LOG.error(I18n.err(I18n.ERR_16047_CANNOT_LOAD_RESOURCE, index, ioe.getMessage()));
                }
            }
        }
        catch (IOException e) {
            LOG.error(I18n.err(I18n.ERR_16045_ERROR_LOADING_RESOURCE, e.getMessage()));
            throw new Error(e);
        }
    }
}

