/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.AbstractContainer;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.TLVStateEnum;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionResponseDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionResponseGrammar;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionResponseStates;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.ControlsContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.ControlsStates;
import org.apache.directory.api.ldap.model.message.Control;

public class EndTransactionResponseContainer
extends AbstractContainer {
    private EndTransactionResponseDecorator endTransactionResponse;
    private static final Asn1Decoder DECODER = new Asn1Decoder();

    public EndTransactionResponseContainer() {
        this.setGrammar(EndTransactionResponseGrammar.getInstance());
        this.setTransition(EndTransactionResponseStates.START_STATE);
    }

    public EndTransactionResponseDecorator getEndTransactionResponse() {
        return this.endTransactionResponse;
    }

    public void setEndTransactionResponse(EndTransactionResponseDecorator endTransactionResponseDecorator) {
        this.endTransactionResponse = endTransactionResponseDecorator;
    }

    @Override
    public void clean() {
        super.clean();
        this.endTransactionResponse = null;
    }

    public static List<Control> decode(byte[] controlsBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlsBytes);
        ControlsContainer container = new ControlsContainer();
        while (bb.hasRemaining()) {
            DECODER.decode(bb, container);
            container.setState(TLVStateEnum.TAG_STATE_START);
            container.setTransition(ControlsStates.START_STATE);
        }
        return container.getControls();
    }
}

