/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.bind;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.BindRequestDecorator;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreVersion
extends GrammarAction<LdapMessageContainer<BindRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreVersion.class);

    public StoreVersion() {
        super("Store BindRequest Version");
    }

    @Override
    public void action(LdapMessageContainer<BindRequestDecorator> container) throws DecoderException {
        BindRequest bindRequestMessage = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        try {
            int version = IntegerDecoder.parse(value, 1, 127);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_05114_LDAP_VERSION, version));
            }
            bindRequestMessage.setVersion3(version == 3);
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err(I18n.ERR_05117_INVALID_VERSION, Strings.dumpBytes(value.getData()), ide.getMessage()));
            throw new DecoderException(ide.getMessage(), ide);
        }
    }
}

