/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.ldapMessage;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMessageId
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreMessageId.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreMessageId() {
        super("Store MessageID");
    }

    @Override
    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err(I18n.ERR_04068, new Object[0]));
            throw new DecoderException(I18n.err(I18n.ERR_04069, new Object[0]));
        }
        BerValue value = tlv.getValue();
        try {
            int messageId = IntegerDecoder.parse(value, 0, Integer.MAX_VALUE);
            container.setMessageId(messageId);
            if (IS_DEBUG) {
                LOG.debug("Ldap Message Id has been decoded : " + messageId);
            }
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err(I18n.ERR_04070, Strings.dumpBytes(value.getData()), ide.getLocalizedMessage()));
            throw new DecoderException(ide.getMessage(), ide);
        }
    }
}

