/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.ldif.anonymizer.Anonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.BinaryAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.IntegerAnonymizer;
import org.apache.directory.api.ldap.model.ldif.anonymizer.StringAnonymizer;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.DnSyntaxChecker;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;

public class LdifAnonymizer {
    Map<Value<?>, Value<?>> valueMap = new HashMap();
    Map<String, Anonymizer> attributeAnonymizers = new HashMap<String, Anonymizer>();
    Set<Dn> namingContexts = new HashSet<Dn>();
    SchemaManager schemaManager;

    public LdifAnonymizer() {
        try {
            this.schemaManager = new DefaultSchemaManager();
        }
        catch (Exception e) {
            System.out.println("Missing a SchemaManager !");
            System.exit(-1);
        }
        this.init();
    }

    public LdifAnonymizer(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.init();
    }

    private void init() {
        this.attributeAnonymizers.put("2.16.840.1.113730.3.1.1", new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.3", new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.13", new StringAnonymizer());
        this.attributeAnonymizers.put("2.16.840.1.113730.3.1.241", new StringAnonymizer());
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.2", new StringAnonymizer());
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.1", new IntegerAnonymizer());
        this.attributeAnonymizers.put("2.5.4.42", new StringAnonymizer());
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.3", new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.20", new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.39", new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.9", new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.51", new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.60", new BinaryAnonymizer());
        this.attributeAnonymizers.put("1.3.6.1.4.1.250.1.57", new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.7", new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.3", new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.10", new StringAnonymizer());
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.12", new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.41", new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.10", new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.11", new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.42", new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.16", new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.7", new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.21", new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.34", new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.4", new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.20", new StringAnonymizer());
        this.attributeAnonymizers.put("0.9.2342.19200300.100.1.1", new StringAnonymizer());
        this.attributeAnonymizers.put("1.3.6.1.1.1.1.0", new IntegerAnonymizer());
        this.attributeAnonymizers.put("2.5.4.36", new StringAnonymizer());
        this.attributeAnonymizers.put("2.5.4.35", new BinaryAnonymizer());
        this.attributeAnonymizers.put("2.16.840.1.113730.3.1.216", new BinaryAnonymizer());
        this.attributeAnonymizers.put("2.16.840.1.113730.3.1.40", new BinaryAnonymizer());
        this.attributeAnonymizers.put("2.5.4.45", new BinaryAnonymizer());
    }

    public void addAnonAttributeType(AttributeType attributeType) throws LdapException {
        this.schemaManager.add(attributeType);
        LdapSyntax syntax = attributeType.getSyntax();
        if (syntax.isHumanReadable()) {
            if (syntax.getOid().equals("1.3.6.1.4.1.1466.115.121.1.27")) {
                this.attributeAnonymizers.put(attributeType.getOid(), new IntegerAnonymizer());
            } else {
                this.attributeAnonymizers.put(attributeType.getOid(), new StringAnonymizer());
            }
        } else {
            this.attributeAnonymizers.put(attributeType.getOid(), new BinaryAnonymizer());
        }
    }

    public void removeAnonAttributeType(AttributeType attributeType) throws LdapException {
        this.attributeAnonymizers.remove(attributeType);
    }

    public void addNamingContext(String dn) throws LdapInvalidDnException {
        Dn namingContext = new Dn(this.schemaManager, dn);
        this.namingContexts.add(namingContext);
    }

    private Ava anonymizeAva(Ava ava) throws LdapInvalidDnException, LdapInvalidAttributeValueException {
        Value<?> value = ava.getValue();
        AttributeType attributeType = ava.getAttributeType();
        Value<?> anonymizedValue = this.valueMap.get(value);
        Ava anonymizedAva = null;
        if (anonymizedValue == null) {
            DefaultAttribute attribute = new DefaultAttribute(attributeType);
            attribute.add(value);
            Anonymizer anonymizer = this.attributeAnonymizers.get(attribute.getAttributeType());
            if (value.isHumanReadable()) {
                if (anonymizer == null) {
                    anonymizedAva = new Ava(this.schemaManager, attributeType.getName(), value.getString());
                } else {
                    Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, attribute);
                    anonymizedAva = new Ava(this.schemaManager, attributeType.getName(), anonymizedAttribute.getString());
                }
            } else if (anonymizer == null) {
                anonymizedAva = new Ava(this.schemaManager, attributeType.getName(), value.getBytes());
            } else {
                Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, attribute);
                anonymizedAva = new Ava(this.schemaManager, attributeType.getName(), anonymizedAttribute.getBytes());
            }
        } else {
            anonymizedAva = value.isHumanReadable() ? new Ava(this.schemaManager, attributeType.getName(), anonymizedValue.getString()) : new Ava(this.schemaManager, attributeType.getName(), anonymizedValue.getBytes());
        }
        return anonymizedAva;
    }

    private Dn anonymizeDn(Dn entryDn) throws LdapException {
        Dn descendant = entryDn;
        Dn namingContext = null;
        for (Dn nc : this.namingContexts) {
            if (!entryDn.isDescendantOf(nc)) continue;
            descendant = entryDn.getDescendantOf(nc);
            namingContext = nc;
            break;
        }
        Rdn[] anonymizedRdns = new Rdn[entryDn.size()];
        int rdnPos = entryDn.size() - 1;
        Iterator<Rdn> iterator = namingContext.iterator();
        while (iterator.hasNext()) {
            Rdn ncRdn;
            anonymizedRdns[rdnPos] = ncRdn = iterator.next();
            --rdnPos;
        }
        for (Rdn rdn : descendant) {
            Rdn anonymizedRdn;
            Ava[] anonymizedAvas = new Ava[rdn.size()];
            int pos = 0;
            for (Ava ava : rdn) {
                Ava anonymizedAva;
                anonymizedAvas[pos] = anonymizedAva = this.anonymizeAva(ava);
                ++pos;
            }
            anonymizedRdns[rdnPos] = anonymizedRdn = new Rdn(this.schemaManager, anonymizedAvas);
            --rdnPos;
        }
        Dn anonymizedDn = new Dn(this.schemaManager, anonymizedRdns);
        return anonymizedDn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String anonymizeFile(String ldifFile) throws LdapException, IOException {
        try (LdifReader ldifReader = new LdifReader(this.schemaManager);){
            List<LdifEntry> entries = ldifReader.parseLdifFile(ldifFile);
            StringBuilder result = new StringBuilder();
            for (LdifEntry ldifEntry : entries) {
                Entry entry = ldifEntry.getEntry();
                DefaultEntry newEntry = new DefaultEntry(this.schemaManager);
                Dn entryDn = entry.getDn();
                Dn anonymizedDn = this.anonymizeDn(entryDn);
                for (Attribute attribute : entry) {
                    AttributeType attributeType = attribute.getAttributeType();
                    if (attributeType.getSyntax().getSyntaxChecker() instanceof DnSyntaxChecker) {
                        for (Value dnValue : attribute) {
                            Dn dn = new Dn(this.schemaManager, dnValue.getString());
                            Dn newdDn = this.anonymizeDn(dn);
                            newEntry.add(attributeType, newdDn.toString());
                        }
                        continue;
                    }
                    int h = attribute.getAttributeType().hashCode();
                    Anonymizer anonymizer = this.attributeAnonymizers.get(attribute.getAttributeType().getOid());
                    if (anonymizer == null) {
                        newEntry.add(attribute);
                        continue;
                    }
                    Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, attribute);
                    newEntry.add(anonymizedAttribute);
                }
                newEntry.setDn(anonymizedDn);
                result.append(LdifUtils.convertToLdif(newEntry));
                result.append("\n");
            }
            String string = result.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String anonymize(String ldif) throws LdapException, IOException {
        try (LdifReader ldifReader = new LdifReader(this.schemaManager);){
            List<LdifEntry> entries = ldifReader.parseLdif(ldif);
            StringBuilder result = new StringBuilder();
            for (LdifEntry ldifEntry : entries) {
                Entry entry = ldifEntry.getEntry();
                DefaultEntry newEntry = new DefaultEntry(this.schemaManager);
                Dn entryDn = entry.getDn();
                Dn anonymizedDn = this.anonymizeDn(entryDn);
                for (Attribute attribute : entry) {
                    AttributeType attributeType = attribute.getAttributeType();
                    if (attributeType.getSyntax().getSyntaxChecker() instanceof DnSyntaxChecker) {
                        for (Value dnValue : attribute) {
                            Dn dn = new Dn(this.schemaManager, dnValue.getString());
                            Dn newdDn = this.anonymizeDn(dn);
                            newEntry.add(attributeType, newdDn.toString());
                        }
                        continue;
                    }
                    Anonymizer anonymizer = this.attributeAnonymizers.get(attribute.getAttributeType());
                    if (anonymizer == null) {
                        newEntry.add(attribute);
                        continue;
                    }
                    Attribute anonymizedAttribute = anonymizer.anonymize(this.valueMap, attribute);
                    newEntry.add(anonymizedAttribute);
                }
                newEntry.setDn(anonymizedDn);
                result.append(LdifUtils.convertToLdif(newEntry));
                result.append("\n");
            }
            String string = result.toString();
            return string;
        }
    }

    public Map<Value<?>, Value<?>> getValueMap() {
        return this.valueMap;
    }

    public void setValueMap(Map<Value<?>, Value<?>> valueMap) {
        this.valueMap = valueMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, LdapException {
        if (args == null || args.length < 1) {
            System.out.println("No file to anonymize");
            return;
        }
        LdifAnonymizer anonymizer = new LdifAnonymizer();
        String ldifString = null;
        try (BufferedReader br = new BufferedReader(new FileReader(args[0]));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            ldifString = sb.toString();
        }
        String result = anonymizer.anonymize(ldifString);
        System.out.println(result);
    }
}

