/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif.anonymizer;

import java.util.Map;
import java.util.Random;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.ldif.anonymizer.Anonymizer;

public class IntegerAnonymizer
implements Anonymizer<String> {
    Random random = new Random(System.currentTimeMillis());

    @Override
    public Attribute anonymize(Map<Value<String>, Value<String>> valueMap, Attribute attribute) {
        DefaultAttribute result = new DefaultAttribute(attribute.getAttributeType());
        this.random.setSeed(System.nanoTime());
        for (Value value : attribute) {
            if (!(value instanceof StringValue)) continue;
            String strValue = value.getString();
            int length = strValue.length();
            char[] newValue = new char[length];
            for (int i = 0; i < length; ++i) {
                newValue[i] = (char)(this.random.nextInt(9) + 48);
            }
            try {
                result.add(new String(newValue));
            }
            catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
        }
        return result;
    }
}

