/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.ldapResult;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMatchedDN
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreMatchedDN.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreMatchedDN() {
        super("Store matched Dn");
    }

    @Override
    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        Dn matchedDn = null;
        ResultCodeEnum resultCode = null;
        ResultResponse response = (ResultResponse)((Object)container.getMessage());
        LdapResult ldapResult = response.getLdapResult();
        resultCode = ldapResult.getResultCode();
        if (tlv.getLength() == 0) {
            matchedDn = Dn.EMPTY_DN;
        } else {
            switch (resultCode) {
                case NO_SUCH_OBJECT: 
                case ALIAS_PROBLEM: 
                case INVALID_DN_SYNTAX: 
                case ALIAS_DEREFERENCING_PROBLEM: {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = Strings.utf8ToString(dnBytes);
                    try {
                        matchedDn = new Dn(dnStr);
                        break;
                    }
                    catch (LdapInvalidDnException ine) {
                        String msg = I18n.err(I18n.ERR_04013, dnStr, Strings.dumpBytes(dnBytes), ine.getLocalizedMessage());
                        LOG.error(msg);
                        throw new DecoderException(I18n.err(I18n.ERR_04014, ine.getLocalizedMessage()), ine);
                    }
                }
                default: {
                    LOG.warn("The matched Dn should not be set when the result code is one of NoSuchObject, AliasProblem, InvalidDNSyntax or AliasDreferencingProblem");
                    matchedDn = Dn.EMPTY_DN;
                }
            }
        }
        if (IS_DEBUG) {
            LOG.debug("The matchedDn is " + matchedDn);
        }
        ldapResult.setMatchedDn(matchedDn);
    }
}

