/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.ldap.client.api.search.AbstractFilter;
import org.apache.directory.ldap.client.api.search.Filter;
import org.apache.directory.ldap.client.api.search.FilterOperator;

class SetOfFiltersFilter
extends AbstractFilter {
    private FilterOperator operator;
    private List<Filter> filters;

    private SetOfFiltersFilter(FilterOperator operator) {
        this.operator = operator;
        this.filters = new ArrayList<Filter>();
    }

    public SetOfFiltersFilter add(Filter filter) {
        this.filters.add(filter);
        return this;
    }

    public SetOfFiltersFilter addAll(Filter ... filters) {
        for (Filter filter : filters) {
            this.filters.add(filter);
        }
        return this;
    }

    public SetOfFiltersFilter addAll(List<Filter> filters) {
        this.filters.addAll(filters);
        return this;
    }

    public static SetOfFiltersFilter and(Filter ... filters) {
        return new SetOfFiltersFilter(FilterOperator.AND).addAll(filters);
    }

    public static SetOfFiltersFilter or(Filter ... filters) {
        return new SetOfFiltersFilter(FilterOperator.OR).addAll(filters);
    }

    @Override
    public StringBuilder build(StringBuilder builder) {
        if (this.filters.isEmpty()) {
            throw new IllegalStateException("at least one filter required");
        }
        builder.append("(").append(this.operator.operator());
        for (Filter filter : this.filters) {
            filter.build(builder);
        }
        return builder.append(")");
    }
}

