/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.vlv_impl;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewRequest;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewRequestImpl;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewRequestContainer;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewerTags;

public class VirtualListViewRequestDecorator
extends ControlDecorator<VirtualListViewRequest>
implements VirtualListViewRequest {
    private int vlvSeqLength;
    private int targetSeqLength;
    private static final Asn1Decoder DECODER = new Asn1Decoder();

    public VirtualListViewRequestDecorator(LdapApiService codec) {
        this(codec, new VirtualListViewRequestImpl());
    }

    public VirtualListViewRequestDecorator(LdapApiService codec, VirtualListViewRequest vlvRequest) {
        super(codec, vlvRequest);
    }

    @Override
    public int computeLength() {
        this.vlvSeqLength = 2 + BerValue.getNbBytes(this.getBeforeCount());
        this.vlvSeqLength += 2 + BerValue.getNbBytes(this.getAfterCount());
        if (this.hasOffset()) {
            this.targetSeqLength = 2 + BerValue.getNbBytes(this.getOffset());
            this.targetSeqLength += 2 + BerValue.getNbBytes(this.getContentCount());
            this.vlvSeqLength += 2 + this.targetSeqLength;
        } else {
            byte[] assertionValue = this.getAssertionValue();
            this.targetSeqLength = assertionValue != null ? 1 + TLV.getNbBytes(assertionValue.length) + assertionValue.length : 2;
            this.vlvSeqLength += this.targetSeqLength;
        }
        if (this.getContextId() != null) {
            this.vlvSeqLength += 1 + TLV.getNbBytes(this.getContextId().length) + this.getContextId().length;
        }
        this.valueLength = 1 + TLV.getNbBytes(this.vlvSeqLength) + this.vlvSeqLength;
        return this.valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes(this.vlvSeqLength));
        BerValue.encode(buffer, this.getBeforeCount());
        BerValue.encode(buffer, this.getAfterCount());
        if (this.hasOffset()) {
            buffer.put((byte)VirtualListViewerTags.BY_OFFSET_TAG.getValue());
            buffer.put(TLV.getBytes(this.targetSeqLength));
            BerValue.encode(buffer, this.getOffset());
            BerValue.encode(buffer, this.getContentCount());
        } else {
            buffer.put((byte)VirtualListViewerTags.ASSERTION_VALUE_TAG.getValue());
            byte[] value = this.getAssertionValue();
            if (value != null) {
                buffer.put(TLV.getBytes(value.length));
                buffer.put(value);
            } else {
                buffer.put(TLV.getBytes(0));
            }
        }
        if (this.getContextId() != null) {
            BerValue.encode(buffer, this.getContextId());
        }
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                this.value = this.encode(buffer).array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer buffer = ByteBuffer.wrap(controlBytes);
        VirtualListViewRequestContainer container = new VirtualListViewRequestContainer(this, this.getCodecService());
        DECODER.decode(buffer, container);
        return this;
    }

    @Override
    public int getBeforeCount() {
        return ((VirtualListViewRequest)this.getDecorated()).getBeforeCount();
    }

    @Override
    public void setBeforeCount(int beforeCount) {
        ((VirtualListViewRequest)this.getDecorated()).setBeforeCount(beforeCount);
    }

    @Override
    public int getAfterCount() {
        return ((VirtualListViewRequest)this.getDecorated()).getAfterCount();
    }

    @Override
    public void setAfterCount(int afterCount) {
        ((VirtualListViewRequest)this.getDecorated()).setAfterCount(afterCount);
    }

    @Override
    public int getOffset() {
        return ((VirtualListViewRequest)this.getDecorated()).getOffset();
    }

    @Override
    public void setOffset(int offset) {
        ((VirtualListViewRequest)this.getDecorated()).setOffset(offset);
    }

    @Override
    public int getContentCount() {
        return ((VirtualListViewRequest)this.getDecorated()).getContentCount();
    }

    @Override
    public void setContentCount(int contentCount) {
        ((VirtualListViewRequest)this.getDecorated()).setContentCount(contentCount);
    }

    @Override
    public byte[] getContextId() {
        return ((VirtualListViewRequest)this.getDecorated()).getContextId();
    }

    @Override
    public void setContextId(byte[] contextId) {
        ((VirtualListViewRequest)this.getDecorated()).setContextId(contextId);
    }

    @Override
    public byte[] getAssertionValue() {
        return ((VirtualListViewRequest)this.getDecorated()).getAssertionValue();
    }

    @Override
    public void setAssertionValue(byte[] assertionValue) {
        ((VirtualListViewRequest)this.getDecorated()).setAssertionValue(assertionValue);
    }

    @Override
    public boolean hasOffset() {
        return ((VirtualListViewRequest)this.getDecorated()).hasOffset();
    }

    @Override
    public boolean hasAssertionValue() {
        return ((VirtualListViewRequest)this.getDecorated()).hasAssertionValue();
    }
}

