/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.param;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Query;
import org.apache.deltaspike.data.api.FirstResult;
import org.apache.deltaspike.data.api.MaxResults;
import org.apache.deltaspike.data.api.QueryParam;
import org.apache.deltaspike.data.api.mapping.QueryInOutMapper;
import org.apache.deltaspike.data.impl.param.IndexedParameter;
import org.apache.deltaspike.data.impl.param.NamedParameter;
import org.apache.deltaspike.data.impl.param.Parameter;
import org.apache.deltaspike.data.impl.param.ParameterUpdate;

public final class Parameters {
    private static final Logger LOG = Logger.getLogger(Parameters.class.getName());
    private static final int DEFAULT_MAX = 0;
    private static final int DEFAULT_FIRST = -1;
    private final List<Parameter> parameterList;
    private final int max;
    private final int firstResult;

    private Parameters(List<Parameter> parameters, int max, int firstResult) {
        this.parameterList = parameters;
        this.max = max;
        this.firstResult = firstResult;
    }

    public static Parameters createEmpty() {
        List<Parameter> empty = Collections.emptyList();
        return new Parameters(empty, 0, -1);
    }

    public static Parameters create(Method method, Object[] parameters) {
        int max = Parameters.extractSizeRestriction(method);
        int first = -1;
        ArrayList<Parameter> result = new ArrayList<Parameter>(parameters.length);
        int paramIndex = 1;
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < parameters.length; ++i) {
            if (Parameters.isParameter(method.getParameterAnnotations()[i])) {
                QueryParam qpAnnotation = Parameters.extractFrom(annotations[i], QueryParam.class);
                if (qpAnnotation != null) {
                    result.add(new NamedParameter(qpAnnotation.value(), parameters[i]));
                    continue;
                }
                result.add(new IndexedParameter(paramIndex++, parameters[i]));
                continue;
            }
            max = Parameters.extractInt(parameters[i], annotations[i], MaxResults.class, max);
            first = Parameters.extractInt(parameters[i], annotations[i], FirstResult.class, first);
        }
        return new Parameters(result, max, first);
    }

    public void applyMapper(QueryInOutMapper<?> mapper) {
        for (Parameter param : this.parameterList) {
            param.applyMapper(mapper);
        }
    }

    public void updateValues(List<ParameterUpdate> updates) {
        for (ParameterUpdate update : updates) {
            for (Parameter param : this.parameterList) {
                if (!param.is(update.forParamWithId())) continue;
                param.updateValue(update.newParamValue(param.queryValue()));
            }
        }
    }

    public Query applyTo(Query query) {
        for (Parameter param : this.parameterList) {
            param.apply(query);
        }
        return query;
    }

    public boolean hasSizeRestriction() {
        return this.max > 0;
    }

    public int getSizeRestriciton() {
        return this.max;
    }

    public boolean hasFirstResult() {
        return this.firstResult > -1;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    private static int extractSizeRestriction(Method method) {
        if (method.isAnnotationPresent(org.apache.deltaspike.data.api.Query.class)) {
            return method.getAnnotation(org.apache.deltaspike.data.api.Query.class).max();
        }
        return 0;
    }

    private static <A extends Annotation> A extractFrom(Annotation[] annotations, Class<A> target) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAssignableFrom(target)) continue;
            return (A)annotation;
        }
        return null;
    }

    private static <A extends Annotation> int extractInt(Object parameter, Annotation[] annotations, Class<A> target, int defaultVal) {
        A result;
        if (parameter != null && (result = Parameters.extractFrom(annotations, target)) != null) {
            if (parameter instanceof Integer) {
                return (Integer)parameter;
            }
            LOG.log(Level.WARNING, "Method parameter extraction: Param type must be int: {0}->is:{1}", new Object[]{target, parameter.getClass()});
        }
        return defaultVal;
    }

    private static boolean isParameter(Annotation[] annotations) {
        return Parameters.extractFrom(annotations, MaxResults.class) == null && Parameters.extractFrom(annotations, FirstResult.class) == null;
    }
}

