/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta.unit;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.deltaspike.data.impl.meta.unit.Descriptor;
import org.apache.deltaspike.data.impl.meta.unit.DescriptorHierarchyBuilder;
import org.apache.deltaspike.data.impl.meta.unit.DescriptorReader;
import org.apache.deltaspike.data.impl.meta.unit.EntityDescriptor;
import org.apache.deltaspike.data.impl.meta.unit.EntityDescriptorReader;
import org.apache.deltaspike.data.impl.meta.unit.MappedSuperclassDescriptor;
import org.apache.deltaspike.data.impl.meta.unit.PersistenceUnit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PersistenceUnitReader
extends DescriptorReader {
    public List<PersistenceUnit> readAll() throws IOException {
        LinkedList<PersistenceUnit> result = new LinkedList<PersistenceUnit>();
        List<Descriptor> persistenceXmls = this.readAllFromClassPath("META-INF/persistence.xml");
        for (Descriptor desc : persistenceXmls) {
            result.addAll(this.lookupUnits(desc));
        }
        return Collections.unmodifiableList(result);
    }

    private List<PersistenceUnit> lookupUnits(Descriptor descriptor) {
        LinkedList<PersistenceUnit> result = new LinkedList<PersistenceUnit>();
        NodeList list = descriptor.getDocument().getDocumentElement().getElementsByTagName("persistence-unit");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            String unitName = this.extractUnitName(node);
            String baseUrl = this.extractBaseUrl(descriptor.getUrl(), "META-INF/persistence.xml");
            List<EntityDescriptor> entities = this.extractMappings((Element)node, baseUrl, unitName);
            result.add(new PersistenceUnit(unitName, entities));
        }
        return result;
    }

    private List<EntityDescriptor> extractMappings(Element element, String baseUrl, String unitName) {
        try {
            EntityDescriptorReader reader = new EntityDescriptorReader();
            LinkedList<EntityDescriptor> entities = new LinkedList<EntityDescriptor>();
            LinkedList<MappedSuperclassDescriptor> superClasses = new LinkedList<MappedSuperclassDescriptor>();
            NodeList list = element.getElementsByTagName("mapping-file");
            this.readMappingFiles(baseUrl, unitName, reader, entities, superClasses, list);
            EntityDescriptorReader.MappingFile mappings = reader.readDefaultOrm(baseUrl);
            entities.addAll(mappings.getEntities());
            superClasses.addAll(mappings.getSuperClasses());
            DescriptorHierarchyBuilder.newInstance(entities, superClasses).buildHierarchy();
            return entities;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed initializing mapping files", e);
        }
    }

    private void readMappingFiles(String baseUrl, String unitName, EntityDescriptorReader reader, List<EntityDescriptor> entities, List<MappedSuperclassDescriptor> superClasses, NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            String resource = list.item(i).getTextContent();
            try {
                EntityDescriptorReader.MappingFile mappings = reader.readAll(baseUrl, resource);
                entities.addAll(mappings.getEntities());
                superClasses.addAll(mappings.getSuperClasses());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("[PersistenceUnit: " + unitName + "] " + "Unable to resolve named mapping-file [" + resource + "]");
            }
        }
    }

    private String extractUnitName(Node node) {
        return node.getAttributes().getNamedItem("name").getTextContent();
    }
}

