/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.criteria.processor;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.deltaspike.data.impl.builder.OrderDirection;
import org.apache.deltaspike.data.impl.criteria.processor.QueryProcessor;

public class OrderBy<P, V>
implements QueryProcessor<P> {
    private final List<OrderByDefinition> orderByDefinitions = new ArrayList<OrderByDefinition>();

    public void add(SingularAttribute<? super P, V> att, OrderDirection dir) {
        this.orderByDefinitions.add(new OrderByDefinition(att, dir));
    }

    @Override
    public <R> void process(CriteriaQuery<R> query, CriteriaBuilder builder, Path<P> path) {
        ArrayList<Order> orders = new ArrayList<Order>();
        block3: for (OrderByDefinition orderByDefinition : this.orderByDefinitions) {
            switch (orderByDefinition.getDir()) {
                case ASC: {
                    orders.add(builder.asc((Expression)path.get(orderByDefinition.getAtt())));
                    continue block3;
                }
            }
            orders.add(builder.desc((Expression)path.get(orderByDefinition.getAtt())));
        }
        query.orderBy(orders);
    }

    private class OrderByDefinition {
        private final SingularAttribute<? super P, V> att;
        private final OrderDirection dir;

        public OrderByDefinition(SingularAttribute<? super P, V> att, OrderDirection dir) {
            this.att = att;
            this.dir = dir;
        }

        public SingularAttribute<? super P, V> getAtt() {
            return this.att;
        }

        public OrderDirection getDir() {
            return this.dir;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrderByDefinition that = (OrderByDefinition)o;
            if (this.att != null ? !this.att.equals(that.att) : that.att != null) {
                return false;
            }
            return this.dir == that.dir;
        }

        public int hashCode() {
            int result = this.att != null ? this.att.hashCode() : 0;
            result = 31 * result + (this.dir != null ? this.dir.hashCode() : 0);
            return result;
        }
    }
}

