/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder.part;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.data.impl.builder.MethodExpressionException;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.builder.QueryBuilderContext;
import org.apache.deltaspike.data.impl.builder.part.OrQueryPart;
import org.apache.deltaspike.data.impl.builder.part.OrderByQueryPart;
import org.apache.deltaspike.data.impl.builder.part.QueryPart;
import org.apache.deltaspike.data.impl.meta.MethodPrefix;
import org.apache.deltaspike.data.impl.meta.RepositoryComponent;
import org.apache.deltaspike.data.impl.param.ParameterUpdate;
import org.apache.deltaspike.data.impl.util.QueryUtils;

public class QueryRoot
extends QueryPart {
    public static final QueryRoot UNKNOWN_ROOT = new QueryRoot("null-object", new MethodPrefix("", null));
    private static final Logger log = Logger.getLogger(QueryRoot.class.getName());
    private final String entityName;
    private final MethodPrefix methodPrefix;
    private String jpqlQuery;
    private List<ParameterUpdate> paramUpdates;

    protected QueryRoot(String entityName, MethodPrefix methodPrefix) {
        this.entityName = entityName;
        this.methodPrefix = methodPrefix;
    }

    public static QueryRoot create(String method, RepositoryComponent repo, MethodPrefix prefix) {
        QueryRoot root = new QueryRoot(repo.getEntityName(), prefix);
        root.build(method, method, repo);
        root.createJpql();
        return root;
    }

    public String getJpqlQuery() {
        return this.jpqlQuery;
    }

    public List<ParameterUpdate> getParameterUpdates() {
        return this.paramUpdates;
    }

    @Override
    protected QueryPart build(String queryPart, String method, RepositoryComponent repo) {
        String[] orderByParts = QueryUtils.splitByKeyword(queryPart, "OrderBy");
        if (this.hasQueryConditions(orderByParts)) {
            String[] orParts = QueryUtils.splitByKeyword(this.removePrefix(orderByParts[0]), "Or");
            boolean first = true;
            for (String or : orParts) {
                OrQueryPart orPart = new OrQueryPart(first);
                first = false;
                this.children.add(orPart.build(or, method, repo));
            }
        }
        if (orderByParts.length > 1) {
            OrderByQueryPart orderByPart = new OrderByQueryPart();
            this.children.add(orderByPart.build(orderByParts[1], method, repo));
        }
        if (this.children.isEmpty()) {
            throw new MethodExpressionException(repo.getRepositoryClass(), method);
        }
        return this;
    }

    @Override
    protected QueryPart buildQuery(QueryBuilderContext ctx) {
        if (this.methodPrefix.isDelete()) {
            ctx.append(QueryBuilder.deleteQuery(this.entityName));
        } else {
            ctx.append(QueryBuilder.selectQuery(this.entityName));
        }
        if (this.hasChildren(this.excludedForWhereCheck())) {
            ctx.append(" where ");
        }
        this.buildQueryForChildren(ctx);
        return this;
    }

    protected String createJpql() {
        QueryBuilderContext ctx = new QueryBuilderContext();
        this.buildQuery(ctx);
        this.jpqlQuery = ctx.resultString();
        this.paramUpdates = ctx.getParameterUpdates();
        log.log(Level.FINER, "createJpql: Query is {0}", this.jpqlQuery);
        return this.jpqlQuery;
    }

    private Set<Class<? extends QueryPart>> excludedForWhereCheck() {
        HashSet<Class<? extends QueryPart>> excluded = new HashSet<Class<? extends QueryPart>>();
        excluded.add(OrderByQueryPart.class);
        return excluded;
    }

    private boolean hasQueryConditions(String[] orderByParts) {
        return !this.methodPrefix.getPrefix().equals(orderByParts[0]);
    }

    private String removePrefix(String queryPart) {
        return this.methodPrefix.removePrefix(queryPart);
    }
}

