/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import jdk.incubator.foreign.MemoryAccess;
import jdk.incubator.foreign.MemorySegment;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.WritableMemoryImpl;

final class NonNativeWritableMemoryImpl
extends WritableMemoryImpl {
    NonNativeWritableMemoryImpl(MemorySegment seg, int typeId, MemoryRequestServer memReqSvr) {
        super(seg, typeId, memReqSvr);
    }

    @Override
    public char getChar(long offsetBytes) {
        return MemoryAccess.getCharAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public void getCharArray(long offsetBytes, char[] dstArray, int dstOffsetChars, int lengthChars) {
        long copyBytes = (long)lengthChars << 1;
        MemorySegment srcSlice = this.seg.asSlice(offsetBytes, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((char[])dstArray).asSlice((long)(dstOffsetChars << 1), copyBytes);
        for (int index = 0; index < lengthChars; ++index) {
            char aChar = MemoryAccess.getCharAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER);
            MemoryAccess.setCharAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER, (char)aChar);
        }
    }

    @Override
    public double getDouble(long offsetBytes) {
        return MemoryAccess.getDoubleAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public void getDoubleArray(long offsetBytes, double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        long copyBytes = (long)lengthDoubles << 3;
        MemorySegment srcSlice = this.seg.asSlice(offsetBytes, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((double[])dstArray).asSlice((long)(dstOffsetDoubles << 3), copyBytes);
        for (int index = 0; index < lengthDoubles; ++index) {
            double dbl = MemoryAccess.getDoubleAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER);
            MemoryAccess.setDoubleAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER, (double)dbl);
        }
    }

    @Override
    public float getFloat(long offsetBytes) {
        return MemoryAccess.getFloatAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public void getFloatArray(long offsetBytes, float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        long copyBytes = (long)lengthFloats << 2;
        MemorySegment srcSlice = this.seg.asSlice(offsetBytes, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((float[])dstArray).asSlice((long)(dstOffsetFloats << 2), copyBytes);
        for (int index = 0; index < lengthFloats; ++index) {
            float flt = MemoryAccess.getFloatAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER);
            MemoryAccess.setFloatAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER, (float)flt);
        }
    }

    @Override
    public int getInt(long offsetBytes) {
        return MemoryAccess.getIntAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public void getIntArray(long offsetBytes, int[] dstArray, int dstOffsetInts, int lengthInts) {
        long copyBytes = (long)lengthInts << 2;
        MemorySegment srcSlice = this.seg.asSlice(offsetBytes, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((int[])dstArray).asSlice((long)(dstOffsetInts << 2), copyBytes);
        for (int index = 0; index < lengthInts; ++index) {
            int anInt = MemoryAccess.getIntAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER);
            MemoryAccess.setIntAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER, (int)anInt);
        }
    }

    @Override
    public long getLong(long offsetBytes) {
        return MemoryAccess.getLongAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public void getLongArray(long offsetBytes, long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        long copyBytes = (long)lengthLongs << 3;
        MemorySegment srcSlice = this.seg.asSlice(offsetBytes, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((long[])dstArray).asSlice((long)(dstOffsetLongs << 3), copyBytes);
        for (int index = 0; index < lengthLongs; ++index) {
            long aLong = MemoryAccess.getLongAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER);
            MemoryAccess.setLongAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER, (long)aLong);
        }
    }

    @Override
    public short getShort(long offsetBytes) {
        return MemoryAccess.getShortAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER);
    }

    @Override
    public void getShortArray(long offsetBytes, short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        long copyBytes = (long)lengthShorts << 1;
        MemorySegment srcSlice = this.seg.asSlice(offsetBytes, copyBytes);
        MemorySegment dstSlice = MemorySegment.ofArray((short[])dstArray).asSlice((long)(dstOffsetShorts << 1), copyBytes);
        for (int index = 0; index < lengthShorts; ++index) {
            short aShort = MemoryAccess.getShortAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER);
            MemoryAccess.setShortAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER, (short)aShort);
        }
    }

    @Override
    public void putChar(long offsetBytes, char value) {
        MemoryAccess.setCharAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER, (char)value);
    }

    @Override
    public void putCharArray(long offsetBytes, char[] srcArray, int srcOffsetChars, int lengthChars) {
        long copyBytes = (long)lengthChars << 1;
        MemorySegment srcSlice = MemorySegment.ofArray((char[])srcArray).asSlice((long)(srcOffsetChars << 1), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(offsetBytes, copyBytes);
        for (int index = 0; index < lengthChars; ++index) {
            char aChar = MemoryAccess.getCharAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER);
            MemoryAccess.setCharAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER, (char)aChar);
        }
    }

    @Override
    public void putDouble(long offsetBytes, double value) {
        MemoryAccess.setDoubleAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER, (double)value);
    }

    @Override
    public void putDoubleArray(long offsetBytes, double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        long copyBytes = (long)lengthDoubles << 3;
        MemorySegment srcSlice = MemorySegment.ofArray((double[])srcArray).asSlice((long)(srcOffsetDoubles << 3), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(offsetBytes, copyBytes);
        for (int index = 0; index < lengthDoubles; ++index) {
            double dbl = MemoryAccess.getDoubleAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER);
            MemoryAccess.setDoubleAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER, (double)dbl);
        }
    }

    @Override
    public void putFloat(long offsetBytes, float value) {
        MemoryAccess.setFloatAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER, (float)value);
    }

    @Override
    public void putFloatArray(long offsetBytes, float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        long copyBytes = (long)lengthFloats << 2;
        MemorySegment srcSlice = MemorySegment.ofArray((float[])srcArray).asSlice((long)(srcOffsetFloats << 2), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(offsetBytes, copyBytes);
        for (int index = 0; index < lengthFloats; ++index) {
            float flt = MemoryAccess.getFloatAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER);
            MemoryAccess.setFloatAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER, (float)flt);
        }
    }

    @Override
    public void putInt(long offsetBytes, int value) {
        MemoryAccess.setIntAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER, (int)value);
    }

    @Override
    public void putIntArray(long offsetBytes, int[] srcArray, int srcOffsetInts, int lengthInts) {
        long copyBytes = (long)lengthInts << 2;
        MemorySegment srcSlice = MemorySegment.ofArray((int[])srcArray).asSlice((long)(srcOffsetInts << 2), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(offsetBytes, copyBytes);
        for (int index = 0; index < lengthInts; ++index) {
            int anInt = MemoryAccess.getIntAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER);
            MemoryAccess.setIntAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER, (int)anInt);
        }
    }

    @Override
    public void putLong(long offsetBytes, long value) {
        MemoryAccess.setLongAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER, (long)value);
    }

    @Override
    public void putLongArray(long offsetBytes, long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        long copyBytes = (long)lengthLongs << 3;
        MemorySegment srcSlice = MemorySegment.ofArray((long[])srcArray).asSlice((long)(srcOffsetLongs << 3), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(offsetBytes, copyBytes);
        for (int index = 0; index < lengthLongs; ++index) {
            long aLong = MemoryAccess.getLongAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER);
            MemoryAccess.setLongAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER, (long)aLong);
        }
    }

    @Override
    public void putShort(long offsetBytes, short value) {
        MemoryAccess.setShortAtOffset((MemorySegment)this.seg, (long)offsetBytes, (ByteOrder)NON_NATIVE_BYTE_ORDER, (short)value);
    }

    @Override
    public void putShortArray(long offsetBytes, short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        long copyBytes = (long)lengthShorts << 1;
        MemorySegment srcSlice = MemorySegment.ofArray((short[])srcArray).asSlice((long)(srcOffsetShorts << 1), copyBytes);
        MemorySegment dstSlice = this.seg.asSlice(offsetBytes, copyBytes);
        for (int index = 0; index < lengthShorts; ++index) {
            short aShort = MemoryAccess.getShortAtIndex((MemorySegment)srcSlice, (long)index, (ByteOrder)NATIVE_BYTE_ORDER);
            MemoryAccess.setShortAtIndex((MemorySegment)dstSlice, (long)index, (ByteOrder)NON_NATIVE_BYTE_ORDER, (short)aShort);
        }
    }
}

