/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.util.ArrayList;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.sampling.PreambleUtil;
import org.apache.datasketches.sampling.ReservoirItemsSketch;
import org.apache.datasketches.sampling.ReservoirSize;
import org.apache.datasketches.sampling.SamplingUtil;

public final class ReservoirItemsUnion<T> {
    private ReservoirItemsSketch<T> gadget_;
    private final int maxK_;

    private ReservoirItemsUnion(int maxK) {
        this.maxK_ = maxK;
    }

    public static <T> ReservoirItemsUnion<T> newInstance(int maxK) {
        return new ReservoirItemsUnion<T>(maxK);
    }

    public static <T> ReservoirItemsUnion<T> heapify(Memory srcMem, ArrayOfItemsSerDe<T> serDe) {
        Family.RESERVOIR_UNION.checkFamilyID(srcMem.getByte(2L));
        int numPreLongs = PreambleUtil.extractPreLongs(srcMem);
        int serVer = PreambleUtil.extractSerVer(srcMem);
        boolean isEmpty = (PreambleUtil.extractFlags(srcMem) & 4) != 0;
        int maxK = PreambleUtil.extractMaxK(srcMem);
        boolean preLongsEqMin = numPreLongs == Family.RESERVOIR_UNION.getMinPreLongs();
        boolean preLongsEqMax = numPreLongs == Family.RESERVOIR_UNION.getMaxPreLongs();
        if (!preLongsEqMin & !preLongsEqMax) {
            throw new SketchesArgumentException("Possible corruption: Non-empty union with only " + Family.RESERVOIR_UNION.getMinPreLongs() + "preLongs");
        }
        if (serVer != 2) {
            if (serVer == 1) {
                short encMaxK = PreambleUtil.extractEncodedReservoirSize(srcMem);
                maxK = ReservoirSize.decodeValue(encMaxK);
            } else {
                throw new SketchesArgumentException("Possible Corruption: Ser Ver must be 2: " + serVer);
            }
        }
        ReservoirItemsUnion<T> riu = new ReservoirItemsUnion<T>(maxK);
        if (!isEmpty) {
            int preLongBytes = numPreLongs << 3;
            Memory sketchMem = srcMem.region((long)preLongBytes, srcMem.getCapacity() - (long)preLongBytes);
            riu.update(sketchMem, serDe);
        }
        return riu;
    }

    public int getMaxK() {
        return this.maxK_;
    }

    public void update(ReservoirItemsSketch<T> sketchIn) {
        boolean isModifiable;
        if (sketchIn == null) {
            return;
        }
        ReservoirItemsSketch<T> ris = sketchIn.getK() <= this.maxK_ ? sketchIn : sketchIn.downsampledCopy(this.maxK_);
        boolean bl = isModifiable = sketchIn != ris;
        if (this.gadget_ == null) {
            this.createNewGadget(ris, isModifiable);
        } else {
            this.twoWayMergeInternal(ris, isModifiable);
        }
    }

    public void update(Memory mem, ArrayOfItemsSerDe<T> serDe) {
        if (mem == null) {
            return;
        }
        ReservoirItemsSketch<T> ris = ReservoirItemsSketch.heapify(mem, serDe);
        ReservoirItemsSketch<T> reservoirItemsSketch = ris = ris.getK() <= this.maxK_ ? ris : ris.downsampledCopy(this.maxK_);
        if (this.gadget_ == null) {
            this.createNewGadget(ris, true);
        } else {
            this.twoWayMergeInternal(ris, true);
        }
    }

    public void update(T datum) {
        if (datum == null) {
            return;
        }
        if (this.gadget_ == null) {
            this.gadget_ = ReservoirItemsSketch.newInstance(this.maxK_);
        }
        this.gadget_.update(datum);
    }

    public void update(long n, int k, ArrayList<T> input) {
        ReservoirItemsSketch<T> ris = ReservoirItemsSketch.newInstance(input, n, ResizeFactor.X8, k);
        ReservoirItemsSketch<T> reservoirItemsSketch = ris = ris.getK() <= this.maxK_ ? ris : ris.downsampledCopy(this.maxK_);
        if (this.gadget_ == null) {
            this.createNewGadget(ris, true);
        } else {
            this.twoWayMergeInternal(ris, true);
        }
    }

    void reset() {
        this.gadget_.reset();
    }

    public ReservoirItemsSketch<T> getResult() {
        return this.gadget_ != null ? this.gadget_.copy() : null;
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe) {
        if (this.gadget_ == null || this.gadget_.getNumSamples() == 0) {
            return this.toByteArray(serDe, null);
        }
        return this.toByteArray(serDe, this.gadget_.getValueAtPosition(0).getClass());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        sb.append(Util.LS);
        sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
        sb.append("   Max k: ").append(this.maxK_).append(Util.LS);
        if (this.gadget_ == null) {
            sb.append("   Gadget is null").append(Util.LS);
        } else {
            sb.append("   Gadget summary: ").append(this.gadget_.toString());
        }
        sb.append("### END UNION SUMMARY").append(Util.LS);
        return sb.toString();
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe, Class<?> clazz) {
        int outBytes;
        int preLongs;
        byte[] gadgetBytes;
        boolean empty = this.gadget_ == null;
        byte[] byArray = gadgetBytes = this.gadget_ != null ? this.gadget_.toByteArray(serDe, clazz) : null;
        if (empty) {
            preLongs = Family.RESERVOIR_UNION.getMinPreLongs();
            outBytes = 8;
        } else {
            preLongs = Family.RESERVOIR_UNION.getMaxPreLongs();
            outBytes = (preLongs << 3) + gadgetBytes.length;
        }
        byte[] outArr = new byte[outBytes];
        WritableMemory mem = WritableMemory.writableWrap((byte[])outArr);
        PreambleUtil.insertPreLongs(mem, preLongs);
        PreambleUtil.insertSerVer(mem, 2);
        PreambleUtil.insertFamilyID(mem, Family.RESERVOIR_UNION.getID());
        if (empty) {
            PreambleUtil.insertFlags(mem, 4);
        } else {
            PreambleUtil.insertFlags(mem, 0);
        }
        PreambleUtil.insertMaxK(mem, this.maxK_);
        if (!empty) {
            int preBytes = preLongs << 3;
            mem.putByteArray((long)preBytes, gadgetBytes, 0, gadgetBytes.length);
        }
        return outArr;
    }

    private void createNewGadget(ReservoirItemsSketch<T> sketchIn, boolean isModifiable) {
        if (sketchIn.getK() < this.maxK_ && sketchIn.getN() <= (long)sketchIn.getK()) {
            this.gadget_ = ReservoirItemsSketch.newInstance(this.maxK_);
            this.twoWayMergeInternal(sketchIn, isModifiable);
        } else {
            this.gadget_ = isModifiable ? sketchIn : sketchIn.copy();
        }
    }

    private void twoWayMergeInternal(ReservoirItemsSketch<T> sketchIn, boolean isModifiable) {
        if (sketchIn.getN() <= (long)sketchIn.getK()) {
            this.twoWayMergeInternalStandard(sketchIn);
        } else if (this.gadget_.getN() < (long)this.gadget_.getK()) {
            ReservoirItemsSketch<T> tmpSketch = this.gadget_;
            this.gadget_ = isModifiable ? sketchIn : sketchIn.copy();
            this.twoWayMergeInternalStandard(tmpSketch);
        } else if (sketchIn.getImplicitSampleWeight() < (double)this.gadget_.getN() / (double)(this.gadget_.getK() - 1)) {
            this.twoWayMergeInternalWeighted(sketchIn);
        } else {
            ReservoirItemsSketch<T> tmpSketch = this.gadget_;
            this.gadget_ = isModifiable ? sketchIn : sketchIn.copy();
            this.twoWayMergeInternalWeighted(tmpSketch);
        }
    }

    private void twoWayMergeInternalStandard(ReservoirItemsSketch<T> source) {
        assert (source.getN() <= (long)source.getK());
        int numInputSamples = source.getNumSamples();
        for (int i = 0; i < numInputSamples; ++i) {
            this.gadget_.update(source.getValueAtPosition(i));
        }
    }

    private void twoWayMergeInternalWeighted(ReservoirItemsSketch<T> source) {
        assert (this.gadget_.getN() >= (long)this.gadget_.getK());
        int numSourceSamples = source.getK();
        double sourceItemWeight = (double)source.getN() / (double)numSourceSamples;
        double rescaled_prob = (double)this.gadget_.getK() * sourceItemWeight;
        double targetTotal = this.gadget_.getN();
        int tgtK = this.gadget_.getK();
        for (int i = 0; i < numSourceSamples; ++i) {
            double rescaled_one = targetTotal += sourceItemWeight;
            assert (rescaled_prob < rescaled_one);
            double rescaled_flip = rescaled_one * SamplingUtil.rand().nextDouble();
            if (!(rescaled_flip < rescaled_prob)) continue;
            int slotNo = SamplingUtil.rand().nextInt(tgtK);
            this.gadget_.insertValueAtPosition(source.getValueAtPosition(i), slotNo);
        }
        long checkN = (long)Math.floor(0.5 + targetTotal);
        this.gadget_.forceIncrementItemsSeen(source.getN());
        assert (checkN == this.gadget_.getN());
    }
}

