/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.datasketches.HashOperations;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.Util;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.QuickSelectSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Summary;

public final class AnotB<S extends Summary> {
    private boolean empty_ = true;
    private long thetaLong_ = Long.MAX_VALUE;
    private long[] hashArr_ = null;
    private S[] summaryArr_ = null;
    private int curCount_ = 0;
    private static final Method GET_CACHE;

    public void setA(Sketch<S> skA) {
        if (skA == null) {
            this.reset();
            throw new SketchesArgumentException("The input argument <i>A</i> may not be null");
        }
        if (skA.isEmpty()) {
            this.reset();
            return;
        }
        this.empty_ = false;
        this.thetaLong_ = skA.getThetaLong();
        DataArrays<S> da = AnotB.getDataArraysA(skA);
        this.hashArr_ = da.hashArr;
        this.summaryArr_ = da.summaryArr;
        this.curCount_ = this.hashArr_.length;
    }

    public void notB(Sketch<S> skB) {
        if (this.empty_ || skB == null || skB.isEmpty() || this.hashArr_ == null) {
            return;
        }
        long thetaLongB = skB.getThetaLong();
        this.thetaLong_ = Math.min(this.thetaLong_, thetaLongB);
        DataArrays daB = AnotB.getResultArraysTuple((long)this.thetaLong_, (int)this.curCount_, (long[])this.hashArr_, this.summaryArr_, skB);
        this.hashArr_ = daB.hashArr;
        this.summaryArr_ = daB.summaryArr;
        this.curCount_ = this.hashArr_.length;
        this.empty_ = this.curCount_ == 0 && this.thetaLong_ == Long.MAX_VALUE;
    }

    public void notB(org.apache.datasketches.theta.Sketch skB) {
        if (this.empty_ || skB == null || skB.isEmpty()) {
            return;
        }
        long thetaLongB = skB.getThetaLong();
        this.thetaLong_ = Math.min(this.thetaLong_, thetaLongB);
        DataArrays daB = AnotB.getResultArraysTheta((long)this.thetaLong_, (int)this.curCount_, (long[])this.hashArr_, this.summaryArr_, (org.apache.datasketches.theta.Sketch)skB);
        this.hashArr_ = daB.hashArr;
        this.summaryArr_ = daB.summaryArr;
        this.curCount_ = this.hashArr_.length;
        this.empty_ = this.curCount_ == 0 && this.thetaLong_ == Long.MAX_VALUE;
    }

    public CompactSketch<S> getResult(boolean reset) {
        if (this.curCount_ == 0) {
            return new CompactSketch(null, null, this.thetaLong_, this.empty_);
        }
        CompactSketch result = new CompactSketch(Arrays.copyOfRange(this.hashArr_, 0, this.curCount_), (Summary[])Arrays.copyOfRange(this.summaryArr_, 0, this.curCount_), this.thetaLong_, this.empty_);
        if (reset) {
            this.reset();
        }
        return result;
    }

    public static <S extends Summary> CompactSketch<S> aNotB(Sketch<S> skA, Sketch<S> skB) {
        if (skA == null || skB == null) {
            throw new SketchesArgumentException("Neither argument may be null");
        }
        if (skA.isEmpty()) {
            return skA.compact();
        }
        if (skB.isEmpty()) {
            return skA.compact();
        }
        DataArrays<S> da = AnotB.getDataArraysA(skA);
        long[] hashArrA = da.hashArr;
        S[] summaryArrA = da.summaryArr;
        int countA = hashArrA.length;
        long minThetaLong = Math.min(skA.getThetaLong(), skB.getThetaLong());
        DataArrays daB = AnotB.getResultArraysTuple((long)minThetaLong, (int)countA, (long[])hashArrA, summaryArrA, skB);
        long[] hashArr = daB.hashArr;
        S[] summaryArr = daB.summaryArr;
        int curCountOut = hashArr.length;
        boolean empty = curCountOut == 0 && minThetaLong == Long.MAX_VALUE;
        CompactSketch result = new CompactSketch(hashArr, summaryArr, minThetaLong, empty);
        return result;
    }

    public static <S extends Summary> CompactSketch<S> aNotB(Sketch<S> skA, org.apache.datasketches.theta.Sketch skB) {
        if (skA == null || skB == null) {
            throw new SketchesArgumentException("Neither argument may be null");
        }
        if (skA.isEmpty()) {
            return skA.compact();
        }
        if (skB.isEmpty()) {
            return skA.compact();
        }
        DataArrays<S> da = AnotB.getDataArraysA(skA);
        long[] hashArrA = da.hashArr;
        S[] summaryArrA = da.summaryArr;
        int countA = hashArrA.length;
        long minThetaLong = Math.min(skA.getThetaLong(), skB.getThetaLong());
        DataArrays daB = AnotB.getResultArraysTheta((long)minThetaLong, (int)countA, (long[])hashArrA, summaryArrA, (org.apache.datasketches.theta.Sketch)skB);
        long[] hashArr = daB.hashArr;
        S[] summaryArr = daB.summaryArr;
        int countOut = hashArr.length;
        boolean empty = countOut == 0 && minThetaLong == Long.MAX_VALUE;
        CompactSketch result = new CompactSketch(hashArr, summaryArr, minThetaLong, empty);
        return result;
    }

    private static <S extends Summary> DataArrays<S> getDataArraysA(Sketch<S> skA) {
        DataArrays da = new DataArrays();
        if (skA instanceof CompactSketch) {
            CompactSketch cskA = (CompactSketch)skA;
            da.hashArr = (long[])cskA.getHashArr().clone();
            da.summaryArr = (Summary[])cskA.getSummaryArr().clone();
        } else {
            CompactSketch cskA = ((QuickSelectSketch)skA).compact();
            da.hashArr = cskA.getHashArr();
            da.summaryArr = cskA.getSummaryArr();
        }
        return da;
    }

    private static <S extends Summary> DataArrays<S> getResultArraysTuple(long minThetaLong, int countA, long[] hashArrA, S[] summaryArrA, Sketch<S> skB) {
        long[] hashTableB;
        DataArrays daB = new DataArrays();
        if (skB instanceof CompactSketch) {
            CompactSketch cskB = (CompactSketch)skB;
            int countB = skB.getRetainedEntries();
            hashTableB = HashOperations.convertToHashTable(cskB.getHashArr(), countB, minThetaLong, 0.9375);
        } else {
            QuickSelectSketch qskB = (QuickSelectSketch)skB;
            hashTableB = qskB.getHashTable();
        }
        long[] tmpHashArrA = new long[countA];
        Class<?> summaryType = summaryArrA.getClass().getComponentType();
        Summary[] tmpSummaryArrA = (Summary[])Array.newInstance(summaryType, countA);
        int lgHTBLen = Util.simpleLog2OfLong(hashTableB.length);
        int nonMatches = 0;
        for (int i = 0; i < countA; ++i) {
            int index;
            long hash = hashArrA[i];
            if (hash == 0L || hash >= minThetaLong || (index = HashOperations.hashSearch(hashTableB, lgHTBLen, hash)) != -1) continue;
            tmpHashArrA[nonMatches] = hash;
            tmpSummaryArrA[nonMatches] = summaryArrA[i];
            ++nonMatches;
        }
        daB.hashArr = Arrays.copyOfRange(tmpHashArrA, 0, nonMatches);
        daB.summaryArr = Arrays.copyOfRange(tmpSummaryArrA, 0, nonMatches);
        return daB;
    }

    private static <S extends Summary> DataArrays<S> getResultArraysTheta(long minThetaLong, int countA, long[] hashArrA, S[] summaryArrA, org.apache.datasketches.theta.Sketch skB) {
        long[] hashTableB;
        long[] thetaCacheB;
        DataArrays daB = new DataArrays();
        try {
            thetaCacheB = (long[])GET_CACHE.invoke((Object)skB, new Object[0]);
        }
        catch (Exception e) {
            throw new SketchesStateException("Reflection Exception " + e);
        }
        if (skB instanceof org.apache.datasketches.theta.CompactSketch) {
            int countB = skB.getRetainedEntries(true);
            hashTableB = HashOperations.convertToHashTable(thetaCacheB, countB, minThetaLong, 0.9375);
        } else {
            hashTableB = thetaCacheB;
        }
        long[] tmpHashArrA = new long[countA];
        Class<?> summaryType = summaryArrA.getClass().getComponentType();
        Summary[] tmpSummaryArrA = (Summary[])Array.newInstance(summaryType, countA);
        int lgHTBLen = Util.simpleLog2OfLong(hashTableB.length);
        int nonMatches = 0;
        for (int i = 0; i < countA; ++i) {
            int index;
            long hash = hashArrA[i];
            if (hash == 0L || hash >= minThetaLong || (index = HashOperations.hashSearch(hashTableB, lgHTBLen, hash)) != -1) continue;
            tmpHashArrA[nonMatches] = hash;
            tmpSummaryArrA[nonMatches] = summaryArrA[i];
            ++nonMatches;
        }
        daB.hashArr = Arrays.copyOfRange(tmpHashArrA, 0, nonMatches);
        daB.summaryArr = Arrays.copyOfRange(tmpSummaryArrA, 0, nonMatches);
        return daB;
    }

    private void reset() {
        this.empty_ = true;
        this.thetaLong_ = Long.MAX_VALUE;
        this.hashArr_ = null;
        this.summaryArr_ = null;
        this.curCount_ = 0;
    }

    static {
        try {
            GET_CACHE = org.apache.datasketches.theta.Sketch.class.getDeclaredMethod("getCache", new Class[0]);
            GET_CACHE.setAccessible(true);
        }
        catch (Exception e) {
            throw new SketchesStateException("Could not reflect getCache(): " + e);
        }
    }

    static class DataArrays<S extends Summary> {
        long[] hashArr;
        S[] summaryArr;

        DataArrays() {
        }
    }
}

