/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapHashIterator;

abstract class HeapCompactSketch
extends CompactSketch {
    private final short seedHash_;
    private final boolean empty_;
    private final int curCount_;
    private final long thetaLong_;
    private final long[] cache_;
    private final int preLongs_;

    HeapCompactSketch(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong) {
        this.empty_ = empty;
        this.seedHash_ = seedHash;
        this.curCount_ = empty ? 0 : curCount;
        this.thetaLong_ = empty ? Long.MAX_VALUE : thetaLong;
        this.cache_ = cache;
        this.preLongs_ = HeapCompactSketch.computeCompactPreLongs(thetaLong, empty, curCount);
    }

    @Override
    public int getCurrentBytes(boolean compact) {
        return this.preLongs_ + this.curCount_ << 3;
    }

    @Override
    public HashIterator iterator() {
        return new HeapHashIterator(this.cache_, this.cache_.length, this.thetaLong_);
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    public boolean hasMemory() {
        return false;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    long[] getCache() {
        return this.cache_;
    }

    @Override
    int getCurrentPreambleLongs(boolean compact) {
        return this.preLongs_;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }

    byte[] toByteArray(boolean ordered) {
        int bytes = this.getCurrentBytes(true);
        byte[] byteArray = new byte[bytes];
        WritableMemory dstMem = WritableMemory.wrap((byte[])byteArray);
        int emptyBit = this.isEmpty() ? 4 : 0;
        int orderedBit = ordered ? 16 : 0;
        byte flags = (byte)(emptyBit | 2 | 8 | orderedBit);
        int preLongs = this.getCurrentPreambleLongs(true);
        HeapCompactSketch.loadCompactMemory(this.getCache(), this.getSeedHash(), this.getRetainedEntries(true), this.getThetaLong(), dstMem, flags, preLongs);
        return byteArray;
    }
}

