/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSummary;

public class UpdatableSketchBuilder<U, S extends UpdatableSummary<U>> {
    private int nomEntries_ = 4096;
    private ResizeFactor resizeFactor_ = DEFAULT_RESIZE_FACTOR;
    private float samplingProbability_ = 1.0f;
    private final SummaryFactory<S> summaryFactory_;
    private static final float DEFAULT_SAMPLING_PROBABILITY = 1.0f;
    private static final ResizeFactor DEFAULT_RESIZE_FACTOR = ResizeFactor.X8;

    public UpdatableSketchBuilder(SummaryFactory<S> summaryFactory) {
        this.summaryFactory_ = summaryFactory;
    }

    public UpdatableSketchBuilder<U, S> setNominalEntries(int nomEntries) {
        this.nomEntries_ = nomEntries;
        return this;
    }

    public UpdatableSketchBuilder<U, S> setResizeFactor(ResizeFactor resizeFactor) {
        this.resizeFactor_ = resizeFactor;
        return this;
    }

    public UpdatableSketchBuilder<U, S> setSamplingProbability(float samplingProbability) {
        if (samplingProbability < 0.0f || samplingProbability > 1.0f) {
            throw new SketchesArgumentException("sampling probability must be between 0 and 1");
        }
        this.samplingProbability_ = samplingProbability;
        return this;
    }

    public UpdatableSketch<U, S> build() {
        return new UpdatableSketch(this.nomEntries_, this.resizeFactor_.lg(), this.samplingProbability_, this.summaryFactory_);
    }

    public void reset() {
        this.nomEntries_ = 4096;
        this.resizeFactor_ = DEFAULT_RESIZE_FACTOR;
        this.samplingProbability_ = 1.0f;
    }
}

