/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors;

import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.processors.Suspension;
import org.apache.daffodil.processors.SuspensionDeadlockException;
import org.apache.daffodil.util.Logger$;
import org.apache.logging.log4j.Level;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4AAF\f\u0001A!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003)\u0011\u0015a\u0003\u0001\"\u0001.\u0011\u001d\u0011\u0004A1A\u0005\nMBaa\u0010\u0001!\u0002\u0013!\u0004b\u0002!\u0001\u0005\u0004%Ia\r\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u001b\t\u000b\t\u0003A\u0011A\"\t\u000fA\u0003\u0001\u0019!C\u0005#\"9!\u000b\u0001a\u0001\n\u0013\u0019\u0006BB-\u0001A\u0003&\u0001\u0006C\u0004[\u0001\u0001\u0007I\u0011B)\t\u000fm\u0003\u0001\u0019!C\u00059\"1a\f\u0001Q!\n!Bqa\u0018\u0001A\u0002\u0013%\u0011\u000bC\u0004a\u0001\u0001\u0007I\u0011B1\t\r\r\u0004\u0001\u0015)\u0003)\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u0015Q\u0007\u0001\"\u0001j\u0011\u0015Y\u0007\u0001\"\u0003m\u0005E\u0019Vo\u001d9f]NLwN\u001c+sC\u000e\\WM\u001d\u0006\u00031e\t!\u0002\u001d:pG\u0016\u001c8o\u001c:t\u0015\tQ2$\u0001\u0005eC\u001a4w\u000eZ5m\u0015\taR$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002=\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0002'M,8\u000f]3og&|gnV1jif{WO\\4\u0011\u0005\tJ\u0013B\u0001\u0016$\u0005\rIe\u000e^\u0001\u0012gV\u001c\b/\u001a8tS>tw+Y5u\u001f2$\u0017A\u0002\u001fj]&$h\bF\u0002/aE\u0002\"a\f\u0001\u000e\u0003]AQaJ\u0002A\u0002!BQaK\u0002A\u0002!\n\u0001c];ta\u0016t7/[8ogf{WO\\4\u0016\u0003Q\u00022!\u000e\u001e=\u001b\u00051$BA\u001c9\u0003\u001diW\u000f^1cY\u0016T!!O\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002<m\t)\u0011+^3vKB\u0011q&P\u0005\u0003}]\u0011!bU;ta\u0016t7/[8o\u0003E\u0019Xo\u001d9f]NLwN\\:Z_Vtw\rI\u0001\u000fgV\u001c\b/\u001a8tS>t7o\u00147e\u0003=\u0019Xo\u001d9f]NLwN\\:PY\u0012\u0004\u0013aC:vgB,gn]5p]N,\u0012\u0001\u0012\t\u0004\u000b6cdB\u0001$L\u001d\t9%*D\u0001I\u0015\tIu$\u0001\u0004=e>|GOP\u0005\u0002I%\u0011AjI\u0001\ba\u0006\u001c7.Y4f\u0013\tquJA\u0002TKFT!\u0001T\u0012\u0002\u000b\r|WO\u001c;\u0016\u0003!\n\u0011bY8v]R|F%Z9\u0015\u0005Q;\u0006C\u0001\u0012V\u0013\t16E\u0001\u0003V]&$\bb\u0002-\u000b\u0003\u0003\u0005\r\u0001K\u0001\u0004q\u0012\n\u0014AB2pk:$\b%A\u000btkN\u0004XM\\:j_:\u001cF/\u0019;Ue\u0006\u001c7.\u001a3\u00023M,8\u000f]3og&|gn\u0015;biR\u0013\u0018mY6fI~#S-\u001d\u000b\u0003)vCq\u0001W\u0007\u0002\u0002\u0003\u0007\u0001&\u0001\ftkN\u0004XM\\:j_:\u001cF/\u0019;Ue\u0006\u001c7.\u001a3!\u0003I\u0019Xo\u001d9f]NLwN\\*uCR\u0014VO\\:\u0002-M,8\u000f]3og&|gn\u0015;biJ+hn]0%KF$\"\u0001\u00162\t\u000fa\u0003\u0012\u0011!a\u0001Q\u0005\u00192/^:qK:\u001c\u0018n\u001c8Ti\u0006$(+\u001e8tA\u0005yAO]1dWN+8\u000f]3og&|g\u000e\u0006\u0002UM\")qM\u0005a\u0001y\u0005\t1/A\bfm\u0006d7+^:qK:\u001c\u0018n\u001c8t)\u0005!\u0016\u0001\u0004:fcVL'/\u001a$j]\u0006d\u0017aE3wC2\u001cVo\u001d9f]NLwN\\)vKV,GC\u0001+n\u0011\u0015qW\u00031\u00015\u0003\u0015\tX/Z;f\u0001")
public class SuspensionTracker {
    private final int suspensionWaitYoung;
    private final int suspensionWaitOld;
    private final Queue<Suspension> suspensionsYoung;
    private final Queue<Suspension> suspensionsOld;
    private int count;
    private int suspensionStatTracked;
    private int suspensionStatRuns;

    private Queue<Suspension> suspensionsYoung() {
        return this.suspensionsYoung;
    }

    private Queue<Suspension> suspensionsOld() {
        return this.suspensionsOld;
    }

    public Seq<Suspension> suspensions() {
        return (Seq)this.suspensionsYoung().toSeq().$plus$plus((GenTraversableOnce)this.suspensionsOld().toSeq(), Seq$.MODULE$.canBuildFrom());
    }

    private int count() {
        return this.count;
    }

    private void count_$eq(int x$1) {
        this.count = x$1;
    }

    private int suspensionStatTracked() {
        return this.suspensionStatTracked;
    }

    private void suspensionStatTracked_$eq(int x$1) {
        this.suspensionStatTracked = x$1;
    }

    private int suspensionStatRuns() {
        return this.suspensionStatRuns;
    }

    private void suspensionStatRuns_$eq(int x$1) {
        this.suspensionStatRuns = x$1;
    }

    public void trackSuspension(Suspension s) {
        this.suspensionsYoung().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Suspension[]{s}));
        this.suspensionStatTracked_$eq(this.suspensionStatTracked() + 1);
    }

    public void evalSuspensions() {
        if (this.count() % this.suspensionWaitOld == 0) {
            this.evalSuspensionQueue(this.suspensionsOld());
        }
        if (this.count() % this.suspensionWaitYoung == 0) {
            this.evalSuspensionQueue(this.suspensionsYoung());
            while (this.suspensionsYoung().nonEmpty()) {
                this.suspensionsOld().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Suspension[]{(Suspension)this.suspensionsYoung().dequeue()}));
            }
        }
        if (this.count() == this.suspensionWaitOld) {
            this.count_$eq(0);
        } else {
            this.count_$eq(this.count() + 1);
        }
    }

    public void requireFinal() {
        BoxedUnit boxedUnit;
        while (this.suspensionsYoung().nonEmpty()) {
            this.suspensionsOld().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Suspension[]{(Suspension)this.suspensionsYoung().dequeue()}));
        }
        this.evalSuspensionQueue(this.suspensionsOld());
        if (this.suspensionsOld().length() == 1) {
            throw Assert$.MODULE$.abort(new StringBuilder(74).append("Invariant broken. ").append("Single suspended expression making no forward progress. ").append(this.suspensionsOld().apply(0)).toString());
        }
        if (this.suspensionsOld().nonEmpty()) {
            throw new SuspensionDeadlockException((Seq<Suspension>)this.suspensionsOld().seq());
        }
        if (Logger$.MODULE$.log().isEnabled(Level.DEBUG)) {
            int arg$macro$1 = this.suspensionStatRuns();
            int arg$macro$2 = this.suspensionStatTracked();
            float arg$macro$3 = (float)this.suspensionStatRuns() / (float)this.suspensionStatTracked() * (float)100;
            org.apache.logging.log4j.scala.Logger$.MODULE$.logMessage$extension1(Logger$.MODULE$.log(), Level.DEBUG, null, (CharSequence)new StringOps("Suspension runs/tracked: %d/%d (%.2f%%)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1), BoxesRunTime.boxToInteger((int)arg$macro$2), BoxesRunTime.boxToFloat((float)arg$macro$3)})), null);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void evalSuspensionQueue(Queue<Suspension> queue) {
        int countOfNotMakingProgress = 0;
        while (!queue.isEmpty() && countOfNotMakingProgress < queue.length()) {
            Suspension s = (Suspension)queue.dequeue();
            this.suspensionStatRuns_$eq(this.suspensionStatRuns() + 1);
            s.runSuspension();
            if (!s.isDone()) {
                queue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Suspension[]{s}));
            }
            if (s.isDone() || s.isMakingProgress()) {
                countOfNotMakingProgress = 0;
                continue;
            }
            ++countOfNotMakingProgress;
        }
    }

    public SuspensionTracker(int suspensionWaitYoung, int suspensionWaitOld) {
        this.suspensionWaitYoung = suspensionWaitYoung;
        this.suspensionWaitOld = suspensionWaitOld;
        this.suspensionsYoung = new Queue();
        this.suspensionsOld = new Queue();
        this.count = 0;
        this.suspensionStatTracked = 0;
        this.suspensionStatRuns = 0;
    }
}

