/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.wadlto;

import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class Option {
    protected File outputDir;
    File[] dependencies;
    File[] redundantDirs;
    List<String> extraargs = new ArrayList<String>();
    String[] bindingFiles = new String[0];
    String catalog;
    private String resourcename;
    private String packagename;
    private Boolean generateImpl;
    private Boolean generateInterface;
    private List<String> schemaPackagenames = new ArrayList<String>();
    private String rx;

    public void setDependencies(File[] files) {
        this.dependencies = files;
    }

    public File[] getDependencies() {
        return this.dependencies;
    }

    public void setDeleteDirs(File[] files) {
        this.redundantDirs = files;
    }

    public File[] getDeleteDirs() {
        return this.redundantDirs;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File f) {
        this.outputDir = f;
    }

    public void setBindingFiles(String[] files) {
        this.bindingFiles = files;
    }

    public String[] getBindingFiles() {
        return this.bindingFiles;
    }

    public void addBindingFile(File file) {
        String[] tmp = new String[this.bindingFiles.length + 1];
        System.arraycopy(this.bindingFiles, 0, tmp, 0, this.bindingFiles.length);
        this.bindingFiles = tmp;
        this.bindingFiles[this.bindingFiles.length - 1] = file.getAbsolutePath();
    }

    public List<String> getSchemaPackagenames() {
        return this.schemaPackagenames;
    }

    public void setSchemaPackagenames(List<String> pn) {
        this.schemaPackagenames = pn;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getPackagename() {
        return this.packagename;
    }

    public void setPackagename(String name) {
        this.packagename = name;
    }

    public void setResourcename(String resourceName) {
        this.resourcename = resourceName;
    }

    public String getResourcename() {
        return this.resourcename;
    }

    public boolean isImpl() {
        return this.generateImpl == null ? false : this.generateImpl;
    }

    public void setImpl(boolean impl) {
        this.generateImpl = impl;
    }

    public boolean isInterface() {
        return this.generateInterface == null ? false : this.generateInterface;
    }

    public void setInterface(boolean interf) {
        this.generateInterface = interf;
    }

    public List<String> getExtraargs() {
        return this.extraargs;
    }

    public void setExtraargs(List<String> ea) {
        this.extraargs.clear();
        this.extraargs.addAll(ea);
    }

    public String getRx() {
        return this.rx;
    }

    public void setRx(String rx) {
        this.rx = rx;
    }

    public void copyOptions(Option destination) {
        destination.setBindingFiles(this.getBindingFiles());
        destination.setCatalog(this.getCatalog());
        destination.setResourcename(this.getResourcename());
        destination.setSchemaPackagenames(this.getSchemaPackagenames());
        destination.setDeleteDirs(this.getDeleteDirs());
        destination.setDependencies(this.getDependencies());
        destination.setOutputDir(this.getOutputDir());
        destination.setExtraargs(this.getExtraargs());
        destination.setRx(this.getRx());
    }

    private <T> T setIfNull(T dest, T source) {
        if (dest == null) {
            dest = source;
        }
        return dest;
    }

    public void merge(Option defaultOptions) {
        this.catalog = this.setIfNull(this.catalog, defaultOptions.catalog);
        this.generateImpl = this.setIfNull(this.generateImpl, defaultOptions.generateImpl);
        this.generateInterface = this.setIfNull(this.generateInterface, defaultOptions.generateInterface);
        this.packagename = this.setIfNull(this.packagename, defaultOptions.packagename);
        this.outputDir = this.setIfNull(this.outputDir, defaultOptions.outputDir);
        this.bindingFiles = this.mergeList(this.bindingFiles, defaultOptions.bindingFiles, String.class);
        this.dependencies = this.mergeList(this.dependencies, defaultOptions.dependencies, File.class);
        this.redundantDirs = this.mergeList(this.redundantDirs, defaultOptions.redundantDirs, File.class);
        this.schemaPackagenames.addAll(defaultOptions.schemaPackagenames);
        this.rx = this.setIfNull(this.rx, defaultOptions.rx);
        this.extraargs.addAll(defaultOptions.extraargs);
    }

    private <T> T[] mergeList(T[] l1, T[] l2, Class<T> cls) {
        if (l1 == null) {
            return l2;
        }
        if (l2 == null) {
            return l1;
        }
        int len = l1.length + l2.length;
        Object[] ret = (Object[])Array.newInstance(cls, len);
        System.arraycopy(l1, 0, ret, 0, l1.length);
        System.arraycopy(l2, 0, ret, l1.length, l2.length);
        return ret;
    }
}

