/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator;

import org.apache.cxf.common.WSDLConstants;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.java2wsdl.generator.AbstractGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSDLGeneratorFactory {
    private WSDLConstants.WSDLVersion wsdlVersion;

    public void setWSDLVersion(WSDLConstants.WSDLVersion v) {
        this.wsdlVersion = v;
    }

    protected String getGeneratorClassName() {
        String pkgName = PackageUtils.getPackageName(this.getClass());
        return pkgName + "." + this.wsdlVersion.toString().toLowerCase() + "." + this.wsdlVersion + "Generator";
    }

    public AbstractGenerator<?> newGenerator() {
        AbstractGenerator generator = null;
        String clzName = this.getGeneratorClassName();
        try {
            generator = (AbstractGenerator)Class.forName(clzName).newInstance();
        }
        catch (Exception e) {
            throw new ToolException("Can not find the Generator for: " + clzName, (Throwable)e);
        }
        return generator;
    }
}

